<?php

namespace PolkurierWebServiceApi;

class Config
{
    private string $apiUrl = 'https://api.polkurier.pl/';

    private int $apiTimeout = 30;

    private int $authLogin = 0;

    private string $authToken = '';

    public function getApiTimeout(): int
    {
        return $this->apiTimeout;
    }

    public function setApiTimeout($apiTimeout): Config
    {
        $this->apiTimeout = $apiTimeout;
        return $this;
    }

    public function getAuthToken(): string
    {
        return $this->authToken;
    }
    

    public function setAuthToken(string $authToken): Config
    {
        $this->authToken = $authToken;
        return $this;
    }


    public function getAuthLogin(): int
    {
        return $this->authLogin;
    }
    

    public function setAuthLogin($authLogin): Config
    {
        $this->authLogin = $authLogin;
        return $this;
    }
    

    public function isEmpty(): bool
    {
        return empty($this->getAuthLogin()) || empty($this->getAuthToken());
    }

    public function getApiUrl(): string
    {
        return $this->apiUrl;
    }

    public function setApiUrl(string $apiUrl): Config
    {
        $this->apiUrl = $apiUrl;
        return $this;
    }
}