<?php

namespace PolkurierWebServiceApi\Entities;

class OrderValuation implements \JsonSerializable
{
    /**
     * @var string
     */
    private $servicecode = '';
    /**
     * @var string
     */
    private $serviceName = '';
    /**
     * @var int
     */
    private $netprice = 0;
    /**
     * @var int
     */
    private $grossprice = 0;
    /**
     * @var bool
     */
    private $shipment = false;

    /**
     * @return string
     */
    public function getServiceCode()
    {
        return $this->servicecode;
    }

    /**
     * @param string $servicecode
     * @return OrderValuation
     */
    public function setServiceCode($servicecode)
    {
        $this->servicecode = (string)$servicecode;
        return $this;
    }

    /**
     * @return int
     */
    public function getGrossPrice()
    {
        return $this->grossprice;
    }

    /**
     * @param int $grossprice
     * @return OrderValuation
     */
    public function setGrossPrice($grossprice)
    {
        $this->grossprice = (float)$grossprice;
        return $this;
    }

    /**
     * @return string
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }

    /**
     * @param string $serviceName
     * @return OrderValuation
     */
    public function setServiceName($serviceName)
    {
        $this->serviceName = (string)$serviceName;
        return $this;
    }

    /**
     * @return int
     */
    public function getNetPrice()
    {
        return $this->netprice;
    }

    /**
     * @param int $netprice
     * @return OrderValuation
     */
    public function setNetPrice($netprice)
    {
        $this->netprice = (float)$netprice;
        return $this;
    }

    /**
     * @return bool
     */
    public function isShipment()
    {
        return $this->shipment;
    }

    /**
     * @param bool $shipment
     * @return OrderValuation
     */
    public function setShipment($shipment)
    {
        $this->shipment = (bool)$shipment;
        return $this;
    }


    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return [
            'servicecode' => $this->getServiceCode(),
            'serviceName' => $this->getServiceName(),
            'netprice' => $this->getNetPrice(),
            'grossprice' => $this->getGrossPrice(),
            'shipment' => $this->isShipment()
        ];
    }
}