<?php

namespace PolkurierWebServiceApi\Entities;


class Sender extends Recipient
{

    private bool $courierAccount = false;
    
    /**
     * @var int
     */
    private $addressBookId;

    public function getCourierAccount(): bool
    {
        return $this->courierAccount;
    }
    
    /**
     * @param mixed $courierAccount
     * @return Sender
     */
    public function setCourierAccount($courierAccount)
    {
        $this->courierAccount = (bool)$courierAccount;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getSenderId()
    {
        return $this->addressBookId;
    }
    
    /**
     * @param mixed $addressBookId
     * @return Sender
     */
    public function setSenderId($addressBookId)
    {
        $this->addressBookId = (int)$addressBookId;
        return $this;
    }

    public function toArray(): array
    {
        $data = parent::toArray();
        $data['courieraccount'] = $this->getCourierAccount();
        $data['addressbookid'] = $this->getSenderId();
        return $data;
    }
}