<?php

namespace PolkurierWebServiceApi\Methods;

use PolkurierWebServiceApi\Response;
use PolkurierWebServiceApi\Util\Arr;

/**
 * Class TestAuthApi
 * @package PolkurierWebServiceApi\Methods
 *
 */
class TestAuthApi extends AbstractMethod
{
    /**
     * @return string
     */
    public function getName()
    {
        return 'test_auth_api';
    }

    /**
     * @return array
     */
    public function getRequestData()
    {
        return [];
    }

    /**
     * @param Response $response
     * @return $this|TestAuthApi
     */
    public function setResponseData(Response $response)
    {
        $this->responseData = (bool)Arr::get($response->get('response'), 'authorization');
        return $this;
    }
}
