<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

use Polkurier\ApiMetod\CancelOrderApi;
use Polkurier\Model\PolkurierConfig;
use Polkurier\Order\OrderDetal;
use Polkurier\Order\OrderPolkurier;
use Polkurier\UpdateConfigPolkurierApi;


class AdminPolkurierOrderModuleController extends ModuleAdminController
{
    private string $pathToTpl = '';
    private string $toolbar_title_controlle = '';

    public function __construct()
    {
        $this->meta_title = 'PRZESYŁKI - POLKURIER.PL';
        $this->table = 'polkurier';
        $this->className = 'AdminPolkurierOrderModule';
        $this->bootstrap = true;
        $this->context = Context::getContext();
        parent::__construct();
        
        $this->polkurierconfig = new PolkurierConfig();
        (new UpdateConfigPolkurierApi($this->polkurierconfig));
        
        $this->toolbar_title_controller = $this->l('PRZESYŁKI - POLKURIER.PL');
    }
    
    public function initToolBarTitle()
    {
        $this->toolbar_title = $this->toolbar_title_controller;
    }
    
    
    public function initContent()
    {
        parent::initContent();
        
        switch (Tools::getValue('action', '')) {
            case 'cancel':
                $this->CancelAction((int)Tools::getValue('idorder', null));
                break;
            case 'detal':
                $this->datal_orderAction((int)Tools::getValue('idorder', null));
                break;
            default:
                $this->indexAction();
                break;
        }
        $this->setContent();
    }
    
    private function setContent(): void
    {
        $this->content .= $this->context->smarty->fetch($this->pathToTpl);
        $this->context->smarty->assign(['content' => $this->content]);
    }
    
    
    private function indexAction(): void
    {
        try {
            $this->pathToTpl = _PS_MODULE_DIR_ . $this->module->name . '/views/templates/admin/list_order.tpl';
            $limit = 50;
            $page = Tools::getValue('p', 1);
            $find['presta_order'] = Tools::getValue('presta_order', '');
            $find['polkurier_order'] = Tools::getValue('polkurier_order', '');
            $find['label_order'] = Tools::getValue('label_order', '');
            
            $order = (new OrderPolkurier())->ListOrders($page, $limit, $find);
            $countorder = 0;
            if ($order) {
                $countorder = OrderPolkurier::CountOrder();
            }
            $this->PaginateList($countorder, $page, $limit);
            $this->context->smarty->assign([
                'orders' => $order,
                'find' => $find
            ]);
        } catch (Exception $ex) {
            $this->context->smarty->assign(['error_mesage_polkurier' => $ex->getMessage()]);
            $this->pathToTpl = _PS_MODULE_DIR_ . $this->module->name . '/views/templates/admin/error.tpl';
        }
    }
    

    private function PaginateList($count_record = 0, $page = 1, $limit = 100): void
    {
        $linkstring = (new Link())->getAdminLink('AdminPolkurierOrderModule', true);
        $pages_nb = ceil($count_record / (int)$limit);
        $range = 5;
        $start = $page - $range;
        if ($start < 1) {
            $start = 1;
        }
        $stop = $page + $range;
        if ($stop > $pages_nb) {
            $stop = (int)$pages_nb;
        }
        
        if (!$page) {
            $page = 1;
        }
        
        $this->context->smarty->assign(['pagination' => [
            'pages_nb' => $pages_nb,
            'prev_p' => $page !== 1 ? $page - 1 : 1,
            'next_p' => (int)$page + 1 > $pages_nb ? $pages_nb : $page + 1,
            'requestPage' => $linkstring,
            'p' => $page,
            'n' => $limit,
            'range' => $range,
            'start' => $start,
            'stop' => $stop,
        ]]);
    }
    
    /**
     * details of the order
     */
    private function datal_orderAction(int $idorder): void
    {
        try {

            $order = (new OrderDetal($idorder))->getDataout();

        } catch (Exception $ex) {
            $this->context->smarty->assign(['error_mesage_polkurier' => $ex->getMessage()]);
            $this->pathToTpl = _PS_MODULE_DIR_ . $this->module->name . '/views/templates/admin/error.tpl';
            return;
        }
        $this->context->smarty->assign($order);
        $this->pathToTpl = _PS_MODULE_DIR_ . $this->module->name . '/views/templates/admin/detal.tpl';
    }

    /**
     * cancellation of orders
     */
    public function CancelAction(int $idorder)
    {
        if ($idorder) {
            
            $orderclass = new OrderPolkurier();

            $order = $orderclass->getOrderById($idorder);
            
            if (is_numeric($order['order_id']) && (int)$order['cancel_order'] !== 1) {
                
                try {

                    $res = (new CancelOrderApi())->cancelOrder($order['number_order']);
                    if (!empty($res)) {
                        $orderclass->setCanceled((int)$order['order_id']);
                    }
                    
                } catch (Exception $ex) {
                    $this->context->smarty->assign(['error_mesage_polkurier' => $ex->getMessage()]);
                    $this->pathToTpl = _PS_MODULE_DIR_ . $this->module->name . '/views/templates/admin/error.tpl';
                    return;
                }
            }
        }
        Tools::redirectAdmin((new Link())->getAdminLink('AdminPolkurierOrderModule', true, [], []));
    }
}