<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

final class ConfigSenderView extends ViewAbstract
{
    protected static string $template = '/views/templates/admin/sender_template_form.tpl';

    public static function getTemplate(): string
    {
        return self::$template;
    }

    public static function getFormConfig(): array
    {
        return [
            'form' => [
                'legend' => [
                    'title' => 'Adres wysyłki',
                ],
                'input' => [
                    [
                        'type' => 'hidden',
                        'name' => 'sender_id'
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Nazwa na liście',
                        'name' => 'name',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Firma',
                        'name' => 'company',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Imię',
                        'name' => 'first_name',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Nazwisko',
                        'name' => 'last_name',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Ulica',
                        'name' => 'street',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Numer budynku',
                        'name' => 'house_no',
                        'maxlength' => 35,
                    
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Numer Lokalu',
                        'name' => 'flat_no',
                        'maxlength' => 35,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Kod pocztowy',
                        'name' => 'postcode',
                        'maxlength' => 10,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Miasto',
                        'name' => 'city',
                        'size' => 20,
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Osoba do kontaktu',
                        'name' => 'contact_name',
                        'maxlength' => 50
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Numer telefonu',
                        'name' => 'phone',
                        'maxlength' => 20
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'E-mail',
                        'name' => 'email',
                        'maxlength' => 100
                    ],
                ],
                'submit' => [
                    'title' => 'Zapisz',
                    'class' => 'button pull-right',
                ]
            ]
        ];
    }
}
