var PolkurierCollectionPoint = {

    InsertCollectionPoint: function (options) {

        options = options || {};
        let props = {
            'id_cart': ID_CART,
            'collection_point': options.id,
            'city': options.city,
            'provider': options.provider,
            'street': options.street,
            'zip': options.zip
        };

        jQuery.ajax({
            type: 'POST',
            url: POLKURIER_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
            async: true,
            cache: false,
            data: {
                'id_cart': ID_CART,
                'collection_point': props.collection_point,
                'providers': props.provider,
                'adres': props.city + ' ' + props.zip + ' ' + props.street,
            },
            success: function () {
                PolkurierCollectionPoint.HideWarning(props.provider);
            },
        });
        let string = props.collection_point + '|' + props.city + ' ' + props.zip + ' ' + props.street;
        jQuery('#input_chosen_point_' + props.provider).val(string);
        jQuery('#chosen_collection_point_' + props.provider).html(string);
    },

    UpdateCollectionPoint: function (provider) {

        let str = jQuery('#input_chosen_point_' + provider).val();
        if (str) {
            let res = str.split("|", 2);
            if (res.length > 1) {
                let adres = res[1];
                let collection_point = res[0];
                jQuery.ajax({
                    type: 'POST',
                    url: POLKURIER_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
                    async: true,
                    cache: false,
                    data: {
                        'id_cart': ID_CART,
                        'collection_point': collection_point,
                        'providers': provider,
                        'adres': adres,
                    },
                    success: function (result) {
                    },
                });
            }
        } else {
            this.clearCollectionPoint();
        }
    },

    clearCollectionPoint: function () {
        jQuery.ajax({
            type: 'POST',
            url: POLKURIER_DELETE_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
            async: true,
            cache: false,
            data: {
                'id_cart': ID_CART
            },
            success: function (result) {
            },
        });
    },

    ShowWarning: function (providers) {
        jQuery('#collection-point-warning-' + providers).show();
    },

    HideWarning: function (providers) {
        jQuery('#collection-point-warning-' + providers).hide();
    },

    isEmptyChosenPoint: function (provider) {
        return jQuery('#input_chosen_point_' + provider).val().length === 0
    },

    getDO: function () {
        if (jQuery('.delivery-options').length) {
            return '.delivery-options';
        }
        return '.delivery-option';
    }
}

jQuery(document).ready(function () {

    let collection = POLKURIER_COLLECTION_POINT_API_CODE || [];

    jQuery('button[name="confirmDeliveryOption"]').click(function (event) {
        let curent_checked = parseInt(jQuery(PolkurierCollectionPoint.getDO() + ' input[type="radio"]:checked').val());
        let provider = collection[curent_checked] || false;
        if (provider) {
            if (PolkurierCollectionPoint.isEmptyChosenPoint(provider)) {
                PolkurierCollectionPoint.ShowWarning(provider);
                event.preventDefault();
            }
        }
    });

    jQuery(PolkurierCollectionPoint.getDO() + ' input[type="radio"]').on('change', function () {
        let pcp = collection[parseInt(jQuery(this).val())] || false;
        if (pcp) {
            PolkurierCollectionPoint.UpdateCollectionPoint(pcp);
        } else {
            PolkurierCollectionPoint.clearCollectionPoint();
        }
    });
});
