<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use ConfigApi;
use Exception;
use Polkurier\ConfigurationKey;
use Polkurier\Model\PolkurierConfig;
use PolkurierWebServiceApi\Auth;
use PolkurierWebServiceApi\Config;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\TestAuthApi;
use PolkurierWebServiceApi\PolkurierWebService;
use RuntimeException;

class ApiClient
{

    private Config $config;

    public function __construct()
    {
        $config = new Config();
        $config->setAuthLogin(PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_ACCOUNT));
        $config->setAuthToken(PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_TOKEN));
        $config->setApiUrl(ConfigApi::$urlapi);
        $config->setApiTimeout(ConfigApi::$apiTimeout);
        $this->config = $config;
    }

    public function checkAPI(): bool
    {
        if ($this->getConfig()->isEmpty()) {
            throw new RuntimeException('Połączenie z serwerem nie jest możliwe, proszę poprawić pola: "User ID" lub "Token API"');
        }
        return $this->validateAuthData();
    }

    public function getConfig(): Config
    {
        return $this->config;
    }

    public function hasEmptyConfig(): bool
    {
        return !is_object($this->getConfig()) || $this->getConfig()->isEmpty();
    }

    /**
     * @return PolkurierWebService
     */
    public function webApi(): PolkurierWebService
    {
        if ($this->hasEmptyConfig()) {

            throw new RuntimeException("Polkurier moduł: Brak Danych konfiguracyjnych API: token i user id");
        }

        try {

            return new PolkurierWebService(new Auth($this->getConfig()), $this->getConfig());

        } catch (ErrorException $ex) {
            throw new RuntimeException($ex->getMessage());
        }
    }


    public function validateAuthData(): bool
    {
        try {

            $method = new TestAuthApi();
            $this->webApi()->requestMethod($method);

        } catch (ErrorException $ex) {

            throw new RuntimeException($ex->getMessage());
        }

        if ($method->getData() !== true) {

            throw new RuntimeException('Brak autoryzacji, proszę sprawdzić pola: "User ID" lub "Token API"');
        }
        return true;
    }
}
