<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use RuntimeException;
use PolkurierWebServiceApi\Entities\Carrier;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\AvailableCarriers;

class AvailableCarriersApi extends ApiClient
{
    /**
     * list of carriers
     * @param bool $additionalData
     * @return Carrier[]
     */
    public function getCarriers($additionalData = false): array
    {
        try{
            $method = new AvailableCarriers();
            $method->setAdditionalData($additionalData);
            $this->webApi()->requestMethod($method);
            $resp = $method->getData();
        }catch (ErrorException $ex){
            throw new RuntimeException($ex->getMessage());
        }

        if (!empty($resp)) {

            foreach ($resp as $item) {

                if (!$item instanceof Carrier) {

                    throw new RuntimeException('API zwróciło nieprawidłowe dane');
                }
            }
        }
        return $resp;
    }
}