<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\GetCourierPoint;

class CourierPointApi extends ApiClient
{

    private array $functions = [];

    private array $couriers = [];

    private string $search_query = '';

    public function getPoint()
    {
        if (!empty($this->couriers) && !empty($this->search_query)) {

            try {

                $method = new GetCourierPoint();

                foreach ($this->functions as $item) {
                    $method->setFunctions($item);
                }

                foreach ($this->couriers as $item) {
                    $method->setCouriers($item);
                }

                $method->setSearchQuery($this->search_query);

                $this->webApi()->requestMethod($method);

                return $method->getData();

            } catch (Exception|ErrorException $ex) {
            }
        }
    }

    public function setFunctions($functions): CourierPointApi
    {
        $this->functions[] = $functions;
        return $this;
    }

    public function setCouriers($couriers): CourierPointApi
    {
        $this->couriers[] = $couriers;
        return $this;
    }

    public function setSearchQuery($search_query): CourierPointApi
    {
        $this->search_query = $search_query;
        return $this;
    }

}