<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use PolkurierWebServiceApi\Methods\GetLabel;

class LabelOrderApi extends ApiClient
{
    private array $order_number = [];

    public function getLabel()
    {
        if (!empty($this->order_number)) {
            try {
                $method = new GetLabel();
                foreach ($this->order_number as $item) {
                    $method->addOrderNumber($item);
                }
                $this->webApi()->requestMethod($method);
                return $method->getData()->getContent();
            } catch (Exception $ex) {
            }
        }
        return null;
    }

    public function setOrderNumber(string $order_number): void
    {
        $this->order_number[] = $order_number;
    }
}