<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\CollectionPoint;

final class CollectionPointModel extends CollectionPointSql
{
    public static function PrepareArray($data = [])
    {
        return [
            'id_cart' => pSQL($data['id_cart']),
            'providers' => pSQL($data['providers']),
            'collection_point' => pSQL($data['collection_point']),
            'adres' => pSQL($data['adres']),
        ];
    }

    public static function Insert($data = [])
    {
        return parent::insertSql(
            self::PrepareArray($data)
        );
    }

    public static function Update($data, $id)
    {
        return parent::updateSql(
            self::PrepareArray($data), $id
        );
    }

    public static function getChosenPoint($id_cart, $providers)
    {
        return parent::getCollectionPointByIdCartProviders((int)$id_cart, pSQL($providers));
    }

    public static function getCollectionPoint($id_cart)
    {
        return parent::getCollectionPointByIdCart((int)$id_cart);
    }

    public static function getCollectionPointOtherProviders($id_cart, $providers)
    {
        return parent::getCollectionPointOtherProviders((int)$id_cart, pSQL($providers));
    }
}