<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */
namespace Polkurier\CoverAddress;

use Polkurier\Sender\PrestaShopDatabaseException;

class SenderCoverAddressModel extends SqlSenderCoverAddress
{
    public static function validateAndPrepareData(array $data = []): array
    {
        if (empty($data)) {
            return [];
        }

        return [
            'name' => pSQL($data['name']),
            'company' => pSQL($data['company']),
            'first_name' => pSQL($data['first_name']),
            'last_name' => pSQL($data['last_name']),
            'street' => pSQL($data['street']),
            'house_no' => pSQL($data['house_no']),
            'flat_no' => pSQL($data['flat_no']),
            'postcode' => pSQL($data['postcode']),
            'city' => pSQL($data['city']),
            'email' => pSQL($data['email']),
            'phone' => pSQL($data['phone']),
            'is_default' => pSQL($data['is_default_']),
        ];
    }

    public static function saveCoverAddress(array $data = [])
    {
        return parent::insertSql(self::validateAndPrepareData($data));
    }

    public static function updateCoverAddress(array $data, int $id)
    {
        return parent::updateSql(self::validateAndPrepareData($data), $id);
    }

    public static function deleteCoverAddress(int $id)
    {
        return parent::deleteSenderCoverAddress($id);
    }


    public static function getList(): array
    {
        $return = [];
        try {

            $result = parent::getAllSenderCoverAddress();

            if(is_array($result)){
                foreach ($result as $item) {
                    $return[$item['id']] = $item;
                }
            }

        } catch (PrestaShopDatabaseException $e) {
            return $return;
        }
        return $return;
    }
}
