<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model;

use Polkurier\Bank\BankListModel;
use Polkurier\CodReturnTime;
use Polkurier\CodType;
use Polkurier\CoverAddress\SenderCoverAddressModel;
use Polkurier\Parcel\ParcelListModel;
use Polkurier\Sender\SenderListModel;

abstract class Model
{
    protected static array $config_value = [];

    /**
     * Lista adresów nadawczych
     * @var SenderListModel
     */
    public static $sender_list;

    /**
     * @var SenderCoverAddressModel
     */
    public static $sender_cover_address_list;

    /**
     * Tablica dostępnych przewoźników
     */
    public static array $couriers = [];

    /**
     * Domyślny typ pickup
     */
    public static string $default_pickup_type = 'COURIER';

    /**
     * Tablica radzajów pickup
     */
    public static array $pickup_courier_type_option = [];

    /**
     * Typ pickup
     */
    public static array $pickup_courier_type = ['COURIER' => true, 'SELF' => false];

    /**
     * domyślny rodzaj przesyłki
     */
    public static string $default_shipment_type = 'box';

    /**
     * lista szablonów paczek - options
     * Pobieranie przez getListOption()
     * @var ParcelListModel
     */
    public $parcel_list_options;

    /**
     * tablica szablonów paczek
     * Pobieranie przez getList()
     * @var ParcelListModel
     */
    public static $parcel_template_list;

    /**
     * Rodzaje przesyłek
     */
    public static array $shipment_type = [];

    /**
     * Lista kont bankowych
     * Pobieranie przez getList()
     * Pobieranie przez getListOption()
     * @var BankListModel
     */
    public static $bank_list;


    /**
     * @var \Polkurier\Model\CountryModel
     */
    public static $countries;

    public static array $codtype = CodType::NAME;

    public static array $cod_return_time = CodReturnTime::NAME;

    public static string $cod_return_time_default = CodReturnTime::DEFAULT_TYPE;

    public static string $return_cod_type = CodType::DEFAULT_TYPE;
}
