<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\Sensbit;

use Db;
use Order;
use PrestaShopDatabaseException;
use Validate;

final class SensbitInpost
{
    /**
     * @param $id_order
     * @return string|null
     */
    public static function getIdMachines($id_order)
    {
        try {

            $order = new Order($id_order);
            if(!Validate::isLoadedObject($order)){
                return null;
            }
            $id_cart = $order->id_cart;

            $collectionpoint = Db::getInstance()->getRow('SELECT * FROM ' . _DB_PREFIX_ . 'sensbitinpost_cart WHERE id_cart = ' . $id_cart .';');
            if (!is_null($collectionpoint) && isset($collectionpoint['parcel_locker_name']) && !empty($collectionpoint['parcel_locker_name'])) {
                return $collectionpoint['parcel_locker_name'];
            }
        } catch (PrestaShopDatabaseException $e) {
        }
        return null;
    }
}