<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Order;
use OrderCarrier;
use Polkurier\ApiMetod\PlaceOrderApi;
use Polkurier\ConfigurationKey;
use Polkurier\Model\PolkurierConfig;
use Polkurier\Model\Shipment\FormShipment\FormShipmentModel;
use Polkurier\Model\Shipment\ShipmentModel;
use Exception;
use RuntimeException;

/**
 * New order - shipping to API
 */
final class CreateNewOrder
{
    private array $dataform = [];

    public function newOrder(): array
    {
        $shipmentmodel = new ShipmentModel();

        (new FormShipmentModel($shipmentmodel, $this->dataform))->SetModel();

        $resp = (new PlaceOrderApi())->getOrder($shipmentmodel);

        if (empty($resp)) {
            throw new RuntimeException('Złożenie zlecenia jest nie możliwe.');
        }

        if (isset($resp['label'][0]) && !empty($resp['label'][0])) {
            $shipmentmodel->setOrderLabel($resp['label'][0]);
        }

        if (isset($resp['order_number']) && !empty($resp['order_number'])) {
            $shipmentmodel->setPolkurierIdOrder($resp['order_number']);
        }

        if (isset($resp['price_gross']) && !empty($resp['price_gross'])) {
            $shipmentmodel->setOrderBrutto((float)$resp['price_gross']);
        }

        if (isset($resp['price_net']) && !empty($resp['price_net'])) {
            $shipmentmodel->setOrderNetto((float)$resp['price_net']);
        }

        if (isset($resp['url_tracktrace']) && !empty($resp['url_tracktrace'])) {
            $shipmentmodel->setUrlTracktrace($resp['url_tracktrace']);
        }


        $ordernewsave = new OrderNewSave($shipmentmodel);
        $ordernewsave->Save();
        $resp['idorder'] = (int)$ordernewsave->getIdOrder();


        if (!empty($shipmentmodel->getOrderLabel())) {
            $objorder = new Order($shipmentmodel->getPrestaIdOrder());
            $order_carrier = new OrderCarrier((int)$objorder->getIdOrderCarrier());
            if ($order_carrier) {
                $order_carrier->tracking_number = $shipmentmodel->getOrderLabel();
                $order_carrier->weight = $shipmentmodel->SumWeightShipmentPack();
                $order_carrier->shipping_cost_tax_incl = $shipmentmodel->getOrderBrutto();
                $order_carrier->update();
            }

            if (PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_SET_ORDER_NEW_SHIPMENT) == 1 && PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_STATUS_ORDER_NEW_SHIPMENT)) {
                UpdatePrestaOrderStatus::Update($shipmentmodel->getPrestaIdOrder(), PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_STATUS_ORDER_NEW_SHIPMENT));
            }
        }
        return $resp;
    }


    public function setDataform($dataform = []): CreateNewOrder
    {
        $this->dataform = $dataform;
        return $this;
    }
}