<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Parcel;

class Parcel
{
    public static function SaveParcelData($data = [])
    {
        $parcel_id = null;
        if (isset($data['parcel_id'])) {

            if (is_numeric($data['parcel_id'])) {

                $parcel_id = $data['parcel_id'];
            }
            unset($data['parcel_id']);
        }
        
        $parcel_field = [
            'name' => '',
            'shipment_type' => '',
            'nstd' => '',
            'content' => '',
            'quantity' => '',
            'weight' => '',
            'dim_1' => '',
            'dim_2' => '',
            'dim_3' => ''
        ];
        
        foreach ($parcel_field as $key => &$item) {
            if (isset($data[$key])) {
                $item = $data[$key];
            }
        }
        
        $empty = true;
        foreach ($parcel_field as $key => &$item) {
            if (!empty($item)) {
                $empty = false;
            }
        }
        
        if (!$empty) {

            if (is_numeric($parcel_id)) {

                return ParcelModel::UpdateParcel($parcel_field, $parcel_id);
            }
            return ParcelModel::InsertParcel($parcel_field);
        }
    }
}