<?php

/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Parcel;

final class ParcelListModel extends ParcelModel
{
    private static array $list = [];

    private static array $list_option = [];

    public static function getList($refresh = false): array
    {
        if (empty(self::$list) || $refresh === true) {
            self::$list = parent::getParcelTemplateList();
        }
        return self::$list;
    }

    public static function getListToJson($refresh = false)
    {
        if (empty(self::$list) || $refresh === true) {
            self::$list = parent::getParcelTemplateList();
        }
        return json_encode(self::$list);
    }

    public static function getListOption($refresh = false): array
    {
        if (empty(self::$list_option) || $refresh === true) {
            self::$list_option = self::getParcelOptions();
        }
        return self::$list_option;
    }

    public static function getListOptionToJson($refresh = false)
    {
        if (empty(self::$list_option) || $refresh === true) {
            self::$list_option = self::getParcelOptions();
        }
        return json_encode(self::$list_option);
    }

    private static function getParcelOptions(): array
    {
        $result = [];
        $list = self::getList();
        if(!empty($list)){
            foreach ($list as $item) {
                $result[$item['parcel_id']] = [
                    'id' => $item['parcel_id'],
                    'name' => $item['name']
                ];
            }
        }
        return $result;
    }
}