<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

if (!defined('_PS_VERSION_')) {
    exit();
}

use PolkurierApi\CollectionPoint\DeliveryPointAddressModule;

class polkurierDetailsPointApiModuleFrontController extends ModuleFrontController
{

    public function postProcess()
    {
        try {

            if (empty(Tools::getValue('apikey')) || !WebserviceKey::isKeyActive(Tools::getValue('apikey'))) {
                $this->getResponse(401);
            }

            $idorder = Tools::getValue('orderid');
            if (empty($idorder) || !(int)$idorder) {
                $this->getResponse(400);
            }

            $response = [];
            $deliveryaddressmodule = new DeliveryPointAddressModule((int)$idorder);
            $collection_point = $deliveryaddressmodule->getDeliveryPoint();
            if (!is_null($collection_point)) {
                $response = [
                    'collectionpoint' => $collection_point,
                ];
            }
            $this->getResponse(200, $response);

        } catch (Exception $e) {
            $this->getResponse(500);
        }
    }


    private function getResponse($status, $data = [])
    {
        $httpStatus = 'OK';
        switch ($status) {
            case 400:
                $httpStatus = 'Bad Request';
                break;
            case 401:
                $httpStatus = 'Unauthorized';
                break;
            case 500:
                $httpStatus = 'Internal Server Error';
                break;
        }

        ob_end_clean();
        header('Content-Type: application/json' . $status . ' ' . $httpStatus, true, $status);
        if (!empty($data)) {
            die(json_encode($data));
        }
        die(json_encode([]));
    }
}
