<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/osl-3.0 osl/osl-3.0
 * @category   module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

require_once __DIR__ . '/../polkurier.php';

/**
 * @param polkurier $module
 * @return bool
 */
function upgrade_module_1_2_2($module)
{
    $carriers_config = json_decode(Polkurier\Model\PolkurierConfig::getConfigValue(Polkurier\ConfigurationKey::POLKURIER_CARRIERS_API_CODE), true);
    $carriers = Polkurier\CarriersList::getCarriers();
    foreach (['DPD_POINT', 'FEDEX_DTR'] as $item) {
        $param = $carriers[$item];
        $idreference = (int)$module->createCarriers($param);
        if($idreference){
            $carriers_config[$idreference] = ['api_code' => $param['api_code']];
        }
    }
    Polkurier\Model\PolkurierConfig::setConfigValue(Polkurier\ConfigurationKey::POLKURIER_CARRIERS_API_CODE, json_encode($carriers_config));
    return true;
}