<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */


final class ConfigSenderCoverAddressView extends ViewAbstract
{
    protected static string $template = '/views/templates/admin/sender_cover_address_template_form.tpl';

    public static function getTemplate(): string
    {
        return self::$template;
    }

    public static function getFormConfig(): array
    {
        return [
            'form' => [
                'legend' => [
                    'title' => 'Adres na etykiecie',
                ],
                'input' => [
                    [
                        'type' => 'hidden',
                        'name' => 'id'
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Nazwa na liście',
                        'name' => 'name',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Firma',
                        'name' => 'company',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Imię',
                        'name' => 'first_name',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Nazwisko',
                        'name' => 'last_name',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Ulica',
                        'name' => 'street',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Numer budynku',
                        'name' => 'house_no',
                        'maxlength' => 35,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Numer Lokalu',
                        'name' => 'flat_no',
                        'maxlength' => 35,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Kod pocztowy',
                        'name' => 'postcode',
                        'maxlength' => 10,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Miasto',
                        'name' => 'city',
                        'size' => 20,
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Numer telefonu',
                        'name' => 'phone',
                        'maxlength' => 20
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'E-mail',
                        'name' => 'email',
                        'maxlength' => 100
                    ],
                    [
                        'col' => 4,
                        'type' => 'checkbox',
                        'label' => 'Domyslny adres na etykiecie',
                        'name' => 'is_default',
                        'values' => [
                            'query' => [
                                [
                                    'val' => '1',
                                    'id' => '',
                                    'name' => '',
                                ]
                            ],
                            'id' => 'id',
                            'name' => 'name'
                        ],
                    ],
                ],
                'submit' => [
                    'title' => 'Zapisz',
                    'class' => 'button pull-right',
                ]
            ]
        ];
    }
}
