<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

use Polkurier\Model\PolkurierConfig;

final class ConfigTemplateView extends ViewAbstract
{
    protected static string $template = '/views/templates/admin/default_form.tpl';

    public static function getTemplate(): string
    {
        return self::$template;
    }

    public static function getFormConfig(): array
    {
        return [
            'form' => [
                'legend' => [
                    'title' => 'Domyślne dane do przesyłek',
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'type' => 'select',
                        'col' => 4,
                        'label' => 'Domyślny przewoźnik do wysyłki',
                        'desc' => '',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_DEFAULT_COURIER,
                        'required' => false,
                        'class' => 'select2',
                        'options' => [
                            'query' => self::getVariables('couriers'),
                            'id' => 'id',
                            'name' => 'name'
                        ]
                    ],
                    [
                        'type' => 'select',
                        'col' => 4,
                        'label' => 'Domyślny odbiór przez kuriera:',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_DEFAULT_PICKUP_TYPE,
                        'required' => false,
                        'class' => 'select2',
                        'options' => [
                            'query' => [
                                [
                                    'id_option' => 'COURIER',
                                    'name' => 'Podjazd kuriera'
                                ],
                                [
                                    'id_option' => 'SELF',
                                    'name' => 'Samodzielnie zamówię/dostarczę do punktu nadawczego'
                                ],

                            ],
                            'id' => 'id_option',
                            'name' => 'name'
                        ]
                    ],
                    [
                        'type' => 'select',
                        'col' => 4,
                        'label' => 'Domyślne ustawienia paczki',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_TEMPLATE_PARCEL_ID,
                        'required' => false,
                        'class' => 'select2',
                        'options' => [
                            'query' => self::getVariables('parcel_list'),
                            'id' => 'id',
                            'name' => 'name'
                        ]
                    ],
                    [
                        'type' => 'select',
                        'col' => 4,
                        'label' => 'Domyślny adres nadawcy',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_DEFAULT_SENDER_ID,
                        'required' => false,
                        'class' => 'select2',
                        'options' => [
                            'query' => self::getVariables('sender_list'),
                            'id' => 'id',
                            'name' => 'name'
                        ]
                    ],

                    [
                        'type' => 'select',
                        'col' => 4,
                        'label' => 'Domyślne konto bankowe',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_DEFAULT_BANK_ID,
                        'required' => false,
                        'class' => 'select2',
                        'options' => [
                            'query' => self::getVariables('template_bank'),
                            'id' => 'id',
                            'name' => 'name'
                        ]
                    ], [
                        'type' => 'select',
                        'col' => 4,
                        'label' => 'Domyślny termin zwrotu pobrania',
                        'desc' => '',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_DEFAULT_RETURN_TIME_COD,
                        'required' => false,
                        'class' => 'select2',
                        'options' => [
                            'query' => self::getVariables('return_time_cod'),
                            'id' => 'id',
                            'name' => 'name'
                        ]
                    ],
                    [
                        'type' => 'select',
                        'col' => 4,
                        'label' => 'Domyślny rodzaj zwrotu pobrania',
                        'desc' => '',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_RETURN_COD_TYPE,
                        'required' => false,
                        'class' => 'select2',
                        'options' => [
                            'query' => self::getVariables('return_cod_type'),
                            'id' => 'id',
                            'name' => 'name'
                        ]
                    ],[
                        'type' => 'switch',
                        'label' => 'Powiadomienie SMS dla odbiorcy',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_SET_ORDER_SMS_NOTIFICATION,
                        'values' => [
                            [
                                'value' => 1,
                                'label' => 'TAK'
                            ],
                            [
                                'value' => 0,
                                'label' => 'NIE'
                            ]
                        ]
                    ]
                ],
                'submit' => [
                    'title' => 'Zapisz',
                ]
            ]
        ];
    }
}
