{*
* @author     polkurier.pl <api@polkurier.pl>
* @copyright  polkurier.pl
* @category   Module
* @package    Presta 8
* @subpackage polkurier
* @link       https://www.polkurier.pl
*}

<div class="panel col-lg-12">
    <input type="submit" id="polkurier_refresh_order_status" class="btn btn-primary pull-right" value="ODŚWIEŻ STATUSY" onclick="RefreshOrderStatus()"/>
    <span id="refresh_order_status_info"></span>
</div>

<div class="panel col-lg-12">
    <div class="panel-heading">
        <i class="icon-search"></i> {l s='Wyszukiwarka'}
    </div>
   <form action="{$link->getAdminLink('AdminPolkurierOrderModule')}" class="form-horizontal" method="POST">
       <div class="row">
           <div class="col-lg-3">
               <label>{l s='Numer zamówienia'}:</label>
               <input type="text" class="form-control" name="presta_order" value="{$find.presta_order}">
           </div>
           <div class="col-lg-2">
               <label>POLKURIER.PL:</label>
               <input type="text" class="form-control" name="polkurier_order" value="{$find.polkurier_order}">
           </div>
           <div class="col-lg-3">
               <label>{l s='Nr listu przewozowego'}:</label>
               <input type="text" class="form-control" name="label_order" value="{$find.label_order}">
           </div>
           <div class="col-lg-2" style="padding-top: 20px">
               <input type="submit" class="btn btn-primary" value="{l s='SZUKAJ'}"/>
           </div>
       </div>
   </form>
</div>

<div class="panel col-lg-12">
    <div class="panel-heading">
        <i class="icon-truck"></i> {l s='Przesyłki'}
        <span class="panel-heading-action">
			<a id="get-waybill" class="list-toolbar-btn" href="">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="Pobierz zaznaczone listy przewozowe" data-html="true" data-placement="top">
                    <i class="icon-truck"></i>
                </span>
            </a>
            <a id="sender-protocol" class="list-toolbar-btn" href="">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="Pobierz zaznaczone protokoły odbioru" data-html="true" data-placement="top">
                    <i class="process-icon-export"></i>
                </span>
            </a>
            <a class="list-toolbar-btn" href="javascript:location.reload();">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="Odśwież listę" data-html="true" data-placement="top">
                    <i class="process-icon-refresh"></i>
                </span>
            </a>
            </span>
    </div>

    {if $pagination}
        {include file='./pagination.tpl' pagination=$pagination}
    {/if}

    <table class="table table-striped table-bordered">
        <thead class="thead-default">
        <tr>
            <th>
                {l s='Data nadania'}
            </th>
            <th>
                {l s='Zamówienie'}
            </th>
            <th>
                POLKURIER.PL
            </th>
            <th>
                {l s='Nr listu przewozowego'}
            </th>
            <th>
                {l s='Adres odbiorcy'}
            </th>
            <th class="text-center">
                {l s='Status przesyłki'}
            </th>
            <th class="text-center" title="Etykiety">
                ETY.
            </th>
            <th class="text-center" title="Protokół nadania">
                PR.N.
            </th>
            <th></th>
            <th></th>
            <th class="text-center">
                <input type="checkbox" id="check-all-elements">
            </th>
        </tr>
        </thead>

        <tbody>
        {foreach from=$orders item=item}
            <tr>
                <td>
                    {$item.created_date|date_format:"%Y-%m-%d %H:%M"}
                </td>
                <td>
                    <a href="{$item.url_presta_order}">{$item.reference}</a>
                </td>
                <td>
                    {$item.number_order}
                </td>
                <td>
                    {$item.number_label}
                </td>
                <td>
                    {$item.receiver}
                </td>
                <td class="text-center">
                    {$item.status}
                </td>
                <td class="text-center" {if $item.cancel_order|default:0 == 1}colspan="3"{/if}>
                    {if $item.cancel_order|default:0 == 0}
                    <div class="btn-group pull-right">
                        <a href="javascript:DownloadLabel({$item.order_id})" class="btn btn-default label-tooltip" data-toggle="tooltip" data-original-title="Etykieta do zamówienia {$item.reference}"
                           data-html="true" data-placement="top" title="Etykieta do zamówienia {$item.reference}">
                            <i class="icon-file-pdf-o" style="color:red;"></i>
                        </a>
                    </div>
                </td>
                <td class="text-center">
                    <div class="btn-group pull-right">
                        <a href="javascript:DownloadProtocol({$item.order_id})" class="btn btn-default label-tooltip" data-toggle="tooltip"
                           data-original-title="Protokół do zamówienia {$item.reference}" data-html="true" data-placement="top" title="Protokół do zamówienia {$item.reference}">
                            <i class="icon-file-pdf-o" style="color:red;"></i>
                        </a>
                    </div>
                </td>
                <td class="text-center">
                    <div class="btn-group pull-right">
                        <a href="{$link->getAdminLink('AdminPolkurierOrderModule', true)}&action=cancel&idorder={$item.order_id}"
                           onclick="if (confirm('Czy napewno anulować przesyłkę?')) return true; else return false;" class="btn btn-default label-tooltip" data-toggle="tooltip"
                           data-original-title="{l s='Anuluj zamówienie'} {$item.number_order}" data-html="true" data-placement="top" title="Anuluj zamówienie {$item.number_order}">
                            <i class="icon-trash-o"></i>
                        </a>
                    </div>
                    {else}
                    ANULOWANE
                    {/if}
                </td>
                <td class="text-center">
                    <div class="btn-group pull-right">
                        <a href="{$link->getAdminLink('AdminPolkurierOrderModule', true)}&action=detal&idorder={$item.order_id}" class="btn btn-default label-tooltip" data-toggle="tooltip"
                           data-original-title="{l s='Szczegóły zamówienia'} {$item.number_order}" data-html="true" data-placement="top" title="Szczegóły zamówienia {$item.number_order}">
                            <i class="icon-search-plus"></i>
                        </a>
                    </div>
                </td>
                <td class="text-center">
                    {if $item.cancel_order|default:0 == 0}
                        <input type="checkbox" value="{$item.order_id}" class="list-checkbox">
                    {/if}
                </td>
            </tr>
        {/foreach}
        </tbody>
    </table>
    {if $pagination}
        {include file='./pagination.tpl' pagination=$pagination}
    {/if}
</div>

{include file='./polkurier_download_file.tpl'}

{literal}
    <script type="text/javascript">
        if (typeof token_adminpolkuriermodule == 'undefined') {
            var token_adminpolkuriermodule = '{/literal}{Tools::getAdminTokenLite('AdminPolkurierModule')}{literal}';
        }

        function ArrayChecked() {
            var arr = [];
            jQuery(".list-checkbox").each(function () {
                if (jQuery(this).is(':checked')) {
                    arr.push(jQuery(this).val());
                }
            });
            return arr;
        }

        jQuery('#get-waybill').on('click', function () {

            var orderlist = ArrayChecked();
            if (orderlist.length === 0) {
                alert('Brak zaznaczonych przesyłek');
                return false;
            }
            DownloadLabel(orderlist);
            return false;
        });

        function RefreshOrderStatus() {

            jQuery('#refresh_order_status_info').html('PROSZĘ CZEKAĆ, TRWA AKTUALIZOWANIE STUSÓW <img src="../img/loader.gif" alt="" border="0" />');

            jQuery.ajax({
                url: POLKURIER_URL_MODULES_AJAX,
                type: "POST",
                data: {
                    action: 'refreshorderstatus',
                    ajax: true,
                    token: '{/literal}{Tools::getAdminTokenLite('AdminPolkurierModule')}{literal}',
                    controller: 'AdminPolkurierModule'
                },
                success: function () {},
                error: function () {}
            }).done(function () {
                jQuery('#refresh_order_status_info').html('ZAKOŃCZONO AKTUALIZOWANIE STUSÓW');
                setTimeout(function () {
                    location.reload();
                }, 2000);
            });
        }

        jQuery('#sender-protocol').on('click', function () {
            var orderlist = ArrayChecked();
            if (orderlist.length === 0) {
                alert('Brak zaznaczonych przesyłek');
                return false;
            }
            DownloadProtocol(orderlist);
            return false;
        });

        jQuery('#check-all-elements').on('click', function () {
            var isChecked = jQuery(this).prop('checked');
            if (isChecked === true) {
                jQuery('.list-checkbox').prop('checked', true);
            } else {
                jQuery('.list-checkbox').prop('checked', false);
            }
        });

        jQuery('.list-checkbox').on('click', function () {
            var items_checked = jQuery('.list-checkbox:checked');
            var items_all = jQuery('.list-checkbox');
            jQuery('#check-all-elements').prop('checked', (items_checked.length == items_all.length));
        });

    </script>
{/literal}
