{*
* @author     polkurier.pl <api@polkurier.pl>
* @copyright  polkurier.pl
* @category   Module
* @package    Presta 8
* @subpackage polkurier
* @link       https://www.polkurier.pl
*}
<div class="panel">
    <div class="panel-heading">
        <i class="icon-cogs"></i> Adres nadawcy
    </div>
    <div class="form-wrapper">
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th style="width: 5%">
                        Lp.
                    </th>
                    <th style="width: 20%">
                        Nazwa
                    </th>
                    <th>
                        Adres
                    </th>
                    <th style="width: 15%"></th>
                </tr>
                </thead>
                <tbody>
                {foreach $sender_list->getList() as $list}
                    <tr>
                        <td>{$list@iteration}</td>
                        <td>{$list.name}</td>
                        <td>{$list.company} {$list.first_name} {$list.last_name}, {$list.street} {$list.house_no} {if $list.flat_no }/{$list.flat_no}{/if}
                            , {$list.postcode} {$list.city}</td>
                        <td>
                            <div class="btn-group pull-right">
                                <a href="{$base_url2}&section=template_sender&action=edit&id={$list.sender_id}" class="btn btn-default" title="Edycja">
                                    <i class="icon-edit"></i> Edycja
                                </a>
                            </div>
                            <div class="btn-group pull-right">
                                <a href="{$base_url2}&section=template_sender&action=deletesender&id={$list.sender_id}"
                                   onclick="if (confirm('Czy napewno usunąć adres?')) return true; else return false;" class="btn btn-default" title="Usuń">
                                    <i class="icon-trash-o"></i> Usuń
                                </a>
                            </div>
                        </td>
                    </tr>
                {/foreach}
                </tbody>
            </table>
        </div>
    </div>
    <div class="panel-footer">
        <a href="{$base_url2}&section=template_sender&action=new" class="btn btn-default pull-right">
            <i class="process-icon-plus"></i> Dodaj
        </a>
    </div>
</div>

<div class="panel">
    <div class="panel-heading">
        <i class="icon-cogs"></i> Adres na etykiecie
    </div>
    <div class="form-wrapper">
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th style="width: 5%">
                        Lp.
                    </th>
                    <th style="width: 20%">
                        Nazwa
                    </th>
                    <th>
                        Adres
                    </th>
                    <th style="width: 15%"></th>
                </tr>
                </thead>
                <tbody>

                {foreach $sender_cover_address_list->getList() as $list}
                    <tr>
                        <td>{$list@iteration}</td>
                        <td>{$list.name}</td>
                        <td>{$list.company} {$list.first_name} {$list.last_name}, {$list.street} {$list.house_no} {if $list.flat_no }/{$list.flat_no}{/if}
                            , {$list.postcode} {$list.city}</td>
                        <td>
                            <div class="btn-group pull-right">
                                <a href="{$base_url2}&section=template_sender_cover_address&action=edit&id={$list.id}" class="btn btn-default" title="Edycja">
                                    <i class="icon-edit"></i> Edycja
                                </a>
                            </div>
                            <div class="btn-group pull-right">
                                <a href="{$base_url2}&section=template_sender_cover_address&action=delete&id={$list.id}"
                                   onclick="if (confirm('Czy napewno usunąć adres?')) return true; else return false;"
                                   class="btn btn-default" title="Usuń">
                                    <i class="icon-trash-o"></i> Usuń
                                </a>
                            </div>
                        </td>
                    </tr>
                {/foreach}
                </tbody>
            </table>
        </div>
    </div>
    <div class="panel-footer">
        <a href="{$base_url2}&section=template_sender_cover_address&action=new" class="btn btn-default pull-right">
            <i class="process-icon-plus"></i> Dodaj
        </a>
    </div>
</div>

<div class="panel">
    <div class="panel-heading">
        <i class="icon-cogs"></i> Szablony paczek
    </div>
    <div class="form-wrapper">
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th style="width: 5%">
                        Lp.
                    </th>
                    <th style="width: 20%">
                        Nazwa
                    </th>
                    <th>
                        Parametry
                    </th>
                    <th style="width: 15%"></th>
                </tr>
                </thead>
                <tbody>
                {foreach $parcel_template_list->getList() as $list}
                    <tr>
                        <td>
                            {$list@iteration}
                        </td>
                        <td>
                            {$list.name}
                        </td>
                        <td>
                            {if isset($shipment_type[$list.shipment_type])}{$shipment_type[$list.shipment_type].name}.{/if}
                            ilość: {$list.quantity|default:0},
                            Niestandard: {if $list.nstd == 1}TAK{else}NIE{/if},
                            długość: {$list.dim_1|default:0}cm,
                            szerokość: {$list.dim_2|default:0}cm,
                            wysokość: {$list.dim_3|default:0}cm,
                            ilość: {$list.quantity|default:1},
                            waga: {$list.weight|default:0}kg
                        </td>
                        <td>
                            <div class="btn-group pull-right">
                                <a href="{$base_url2}&section=template_parcel&action=edit&id={$list.parcel_id}" class="btn btn-default" title="Edycja">
                                    <i class="icon-edit"></i> Edycja
                                </a>
                            </div>
                            <div class="btn-group pull-right">
                                <a href="{$base_url2}&section=template_parcel&action=delete_parcel&id={$list.parcel_id}"
                                   onclick="if (confirm('Czy napewno usunąć szablon?')) return true; else return false;" class="btn btn-default" title="Usuń">
                                    <i class="icon-trash-o"></i> Usuń
                                </a>
                            </div>
                        </td>
                    </tr>
                {/foreach}
                </tbody>
            </table>
        </div>
    </div>
    <div class="panel-footer">
        <a href="{$base_url2}&section=template_parcel&action=new" class="btn btn-default pull-right">
            <i class="process-icon-plus"></i> Dodaj
        </a>
    </div>
</div>

<div class="panel">
    <div class="panel-heading">
        <i class="icon-cogs"></i> Numery kont bankowych
    </div>
    <div class="form-wrapper">
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th style="width: 5%">
                        Lp.
                    </th>
                    <th style="width: 20%">
                        Nazwa
                    </th>
                    <th>
                        Numer
                    </th>
                    <th style="width: 15%"></th>
                </tr>
                </thead>
                <tbody>
                {foreach $bank_list->getList() as $list}
                    <tr>
                        <td>
                            {$list@iteration}
                        </td>
                        <td>
                            {$list.name}
                        </td>
                        <td>
                            {$list.iban}
                        </td>
                        <td>
                            <div class="btn-group pull-right">
                                <a href="{$base_url2}&section=template_bank&action=edit&id={$list.bank_id}" class="btn btn-default" title="Edycja">
                                    <i class="icon-edit"></i> Edycja
                                </a>
                            </div>
                            <div class="btn-group pull-right">
                                <a href="{$base_url2}&section=template_bank&action=delete_bank&id={$list.bank_id}"
                                   onclick="if (confirm('Czy napewno usunąć numer konta bankowego?')) return true; else return false;" class="btn btn-default" title="Usuń">
                                    <i class="icon-trash-o"></i> Usuń
                                </a>
                            </div>
                        </td>
                    </tr>
                {/foreach}
                </tbody>
            </table>
        </div>
    </div>
    <div class="panel-footer">
        <a href="{$base_url2}&section=template_bank&action=new" class="btn btn-default pull-right">
            <i class="process-icon-plus"></i> Dodaj
        </a>
    </div>
</div>
{literal}
<script type="text/javascript">
    var POLKURIER_MODULE_TOKEN = '{/literal}{$polkurier_token}{literal}';
    var POLKURIER_URL_MODULES_AJAX = 'ajax-tab.php';
    var POLKURIER_SENDER_POINT_INPOST_PACZKOMAT = "{/literal}{$polkurier_sender_point_inpost_paczkomat}{literal}";
    var POLKURIER_SENDER_POINT_POCZTEX = "{/literal}{$polkurier_sender_point_pocztex_punkt}{literal}";
    var POLKURIER_SENDER_POINT_DPD = "{/literal}{$polkurier_sender_point_dpd}{literal}";
    var POLKURIER_SENDER_POINT_UPS = "{/literal}{$polkurier_sender_point_ups}{literal}";

    var PolkurierCollectionPoint = {

        LoadCourierPoint: function (options) {

            options = options || {};
            var props = {
                'select': options.select,
                'functions': options.functions || [],
                'couriers': options.couriers || ['INPOST_PACZKOMAT'],
                'searchquery': options.searchquery
            }

            let select = jQuery('#' + options.select);
            select.select2({
                minimumInputLength: 3,
                ajax: {
                    url: POLKURIER_URL_MODULES_AJAX,
                    dataType: 'json',
                    type: "POST",
                    quietMillis: 1000,
                    data: function (params) {
                        return {
                            'ajax': true,
                            'action': 'courierpoint',
                            'token': POLKURIER_MODULE_TOKEN,
                            'controller': 'AdminPolkurierModule',
                            'couriers': props.couriers,
                            'functions': props.functions,
                            'searchquery': params.term
                        };
                    },
                    processResults: function (result) {
                        return {
                            results: PolkurierCollectionPoint.PrepareResults(result)
                        };
                    },
                },
                placeholder: "wpisz nazwę punktu, kod pocztowy lub miasto",
                allowClear: true,
                width: '100%',
                theme: "classic",
                language: "pl",
            });
            this.PreloadSelect2(select, props);
        },

        PrepareResults: function (result) {
            let myResults = [];
            if (result.status === true) {
                if (result.data) {
                    jQuery.each(result.data, function (index, item) {
                        myResults.push({
                            'id': item.id,
                            'text': '[' + item.id + '] ' + item.street + ' ' + item.zip + ' ' + item.city
                        });
                    });
                }
            }
            return myResults;
        },

        PreloadSelect2: function (select, options) {
            jQuery.ajax({
                url: POLKURIER_URL_MODULES_AJAX,
                type: "POST",
                dataType: 'json',
                data: {
                    'ajax': true,
                    'action': 'courierpoint',
                    'token': POLKURIER_MODULE_TOKEN,
                    'controller': 'AdminPolkurierModule',
                    'couriers': options.couriers,
                    'functions': options.functions,
                    'searchquery': options.searchquery
                },
                success: function (result) {
                    let items = PolkurierCollectionPoint.PrepareResults(result);
                    jQuery.each(items, function (index, item) {
                        let newOption = new Option(item.text, item.id, false, false);
                        select.append(newOption).trigger('change');
                    });
                }
            });
        },
    }

    jQuery(document).ready(function () {

        jQuery('.select2').select2({
            language: "pl",
            theme: "classic",
            width: '100%'
        });

        PolkurierCollectionPoint.LoadCourierPoint({
            'select': 'POLKURIER_SENDER_POINT_INPOST_PACZKOMAT',
            'functions': ['send'],
            'couriers': ['INPOST_PACZKOMAT'],
            'searchquery': POLKURIER_SENDER_POINT_INPOST_PACZKOMAT
        });

        PolkurierCollectionPoint.LoadCourierPoint({
            'select': 'POLKURIER_SENDER_POINT_KURIER48',
            'functions': ['send'],
            'couriers': ['POCZTEX_PUNKT'],
            'searchquery': POLKURIER_SENDER_POINT_POCZTEX
        });

        PolkurierCollectionPoint.LoadCourierPoint({
            'select': 'POLKURIER_SENDER_POINT_DPD',
            'functions': ['send'],
            'couriers': ['DPD_POINT'],
            'searchquery': POLKURIER_SENDER_POINT_DPD
        });

        PolkurierCollectionPoint.LoadCourierPoint({
            'select': 'POLKURIER_SENDER_POINT_UPS',
            'functions': ['send'],
            'couriers': ['UPS_AP_POINT_POINT'],
            'searchquery': POLKURIER_SENDER_POINT_UPS
        });
    });
</script>
{/literal}
