{*
* @author     polkurier.pl <api@polkurier.pl>
* @copyright  polkurier.pl
* @category   Module
* @package    Presta 8
* @subpackage polkurier
* @link       https://www.polkurier.pl
*}
{literal}
    <style type="text/css">
        .parcel_form {
            background-color: #fafafa;
            border: 2px solid white;
        }

        .row-str:nth-of-type(odd) {
            background-color: #efefef;
        }

        .row-str:nth-of-type(even) {
            background-color: #ffffff;
        }

        .chosen-container {
            width: 100% !important;
        }

        .company-button-container-valuation {
            cursor: pointer;
            display: inline-block;
            margin: 3px;
            width: 175px;
            border: solid 1px #c7d6db;
            border-radius: 6px;
            text-align: center;
        }

        .company-button-container-valuation:hover, .company-button-container-valuation.active {
            padding: -3px;
            margin: 3px;
            border: solid 2px #00aff0;

        }

        .company-button-container-valuation .courierfullinfo {
            padding-top: 5px;
            font-weight: bold;
            font-size: 12px;
        }

        .container-carrier-valuation {
            position: relative;
            padding-bottom: 1px;
            margin-top: 2px;
            margin-bottom: 2px;
        }

        .carrier-text-valuation {
            margin-top: 10px;
            background: #f6f6f6;
            padding: 3px 0;
            text-align: center;
            border-radius: 0 0 6px 6px;
        }

        .carrier-price-valuation {
            padding-top: 0;
            font-size: 10px;
            margin-top: -3px;
        }
    </style>
{/literal}
{if $polkurier_error_msg}
    {foreach from=$polkurier_error_msg item=error}
        {$error}
    {/foreach}
{/if}

{if $polkurier_confirm_msg}
    {foreach from=$polkurier_confirm_msg item=confirm}
        {$confirm}
    {/foreach}
{/if}

{if $show_order_form == true}
    <div class="bootstrap">

        <div class="card panel">
            <div class="card-header panel-heading" style="padding: 10px">
                <div class="row">
                    <div class="col-md-6">
                        <img src="{_PS_BASE_URL_}/modules/polkurier/views/img/logo.png" height="30px"
                             alt="polkurier.pl"> {l s='POLKURIER.PL - TANIE PRZESYŁKI KURIERSKIE'}
                    </div>
                    <div class="col-md-6 text-right">
                        <input type="button" id="polkurier_show_hide_form" class="btn btn-primary" data-token="{Tools::getAdminTokenLite('AdminPolkurierModule')}"
                               value="{l s='NADAJ PRZESYŁKĘ'}">
                    </div>
                </div>
            </div>

            <div class="card-body panel-body" style="display:none;" id="polkurier_order_form_div">
                <div class="row-margin-top">
                    <form action="" id="polkurier_order_form" class="bootstrap form-horizontal">
                        <input type="hidden" value="{$shipmentmodel->getPrestaIdOrder()}" name="presta_id_order">
                        <div class="text-center row-margin-bottom row-margin-top">
                            <h3>{l s='Przed zamówieniem kuriera upewnij się czy poniższe dane są prawidłowe.'}</h3>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div style="font-weight: bold;" class="text-center form-group">
                                    {l s='Nadawca'}
                                </div>

                                <div class="row form-group">
                                    <div class="col-lg-4 text-right">
                                        <label>{l s='Szablony adresów'}:</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <select id="sender_tempalte_id" class="polkurier_select2" style="width: 100%">
                                            <option value="">---</option>
                                            {foreach from=$sender_list item=contact}
                                                <option value="{$contact.sender_id}" {if $contact.sender_id == $POLKURIER_DEFAULT_SENDER_ID} selected="selected" {/if}>{$contact.name} </option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>

                                {*--------------------Punkt nadawca--------------*}
                                <div class="row form-group pk_station_list_box mt-3 mb-3"
                                     id="pk_station_list_box_sender" style="display: none">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Punkt nadania przesyłki'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-6">
                                        <select name="sender[station]" id="polkurier_sender_station" autocomplete="off"
                                                class="polkurier_select2" style="width: 100% auto;"></select>
                                    </div>
                                    <div class="col-lg-2">
                                        <input type="button" data-target="sender"
                                               class="btn btn-sm btn-outline-secondary show_courier_point_map"
                                               value="{l s='mapka'}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label>
                                            {l s='Nazwa firmy'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" id="sender_company"
                                               name="sender[company]" maxlength="35"
                                               value="{$shipmentmodel->getSender()->getCompany()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label>
                                            {l s='Imie'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" id="sender_firstname"
                                               name="sender[firstname]" maxlength="35"
                                               value="{$shipmentmodel->getSender()->getFirstname()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label>
                                            {l s='Nazwisko'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" id="sender_lastname"
                                               name="sender[lastname]" maxlength="35"
                                               value="{$shipmentmodel->getSender()->getLastname()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Nazwa ulicy'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" required="required" id="sender_street"
                                               name="sender[street]" maxlength="35"
                                               value="{$shipmentmodel->getSender()->getStreet()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Numer bydynku'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" required="required" id="sender_house_no"
                                               name="sender[house_no]" maxlength="6"
                                               value="{$shipmentmodel->getSender()->getHouseNo()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label>
                                            {l s='Numer lokalu'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="sender[flat_no]"
                                               id="sender_flat_no" maxlength="6"
                                               value="{$shipmentmodel->getSender()->getFlatNo()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Kod pocztowy'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" required="required" id="sender_postcode"
                                               name="sender[postcode]" maxlength="10"
                                               value="{$shipmentmodel->getSender()->getPostcode()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Miasto'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" required="required" id="sender_city"
                                               name="sender[city]" maxlength="35"
                                               value="{$shipmentmodel->getSender()->getCity()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Osoba kontaktowa'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" required="required"
                                               name="sender[contact_name]" id="sender_contact_name" maxlength="35"
                                               value="{$shipmentmodel->getSender()->getContactName()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Telefon'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" required="required" name="sender[phone]"
                                               id="sender_phone" maxlength="15"
                                               value="{$shipmentmodel->getSender()->getPhone()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='E-mail'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="sender[email]" id="sender_email"
                                               maxlength="100"
                                               value="{$shipmentmodel->getSender()->getEmail()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label>
                                            {l s='Szablony adresów na etykiecie'}:
                                            <i class="material-icons"
                                               data-toggle="pstooltip"
                                               data-placement="bottom"
                                               data-original-title="Jeśli chcesz ukryć swoje aktualne dane nadawcy, możesz wybrać jeden z dostępnych szablonów adresów. Jeśli nie chcesz używać szablonu, pozostaw pole niewybrane.">info</i>
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <select id="sender_cover_address_tempalte_id"
                                                name="sender[cover_address_template_id]"
                                                class="polkurier_select2" style="width: 100%">
                                            <option value="0">---</option>
                                            {foreach from=$sender_cover_address_list item=contact}
                                                <option value="{$contact.id}" {if $contact.is_default == 1} selected="selected" {/if}>{$contact.name}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>

                            </div>
                            <div class="col-lg-6">
                                <div style="font-weight: bold;" class="text-center row-margin-bottom">
                                    {l s='Odbiorca'}
                                </div>
                                <div class="row form-group">
                                    <div class="col-lg-4 text-right">
                                        <label></label>
                                    </div>
                                    <div class="col-lg-8" style="min-height: 30px"></div>
                                </div>

                                <div class="row form-group pk_station_list_box mt-3 mb-3"
                                     id="pk_station_list_box_receiver" style="display: none">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Punkt odbioru przesyłki'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-6">
                                        <select name="receiver[station]" id="polkurier_receiver_station"
                                                autocomplete="off" class="polkurier_select2"
                                                style="width: 100%;"></select>
                                    </div>
                                    <div class="col-lg-2">
                                        <input type="button" data-target="receiver"
                                               class="btn btn-sm btn-outline-secondary show_courier_point_map"
                                               value="mapka">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Nazwa firmy'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[company]"
                                               id="receiver_company" maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getCompany()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Imie'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[firstname]"
                                               id="receiver_firstname" maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getFirstname()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Nazwisko'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[lastname]"
                                               id="receiver_lastname" maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getLastname()}"
                                               required="required">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Ulica'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[street]"
                                               id="receiver_street" maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getStreet()}"
                                               required="required">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Numer budynku'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[house_no]"
                                               id="receiver_house_no" maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getHouseNo()}"
                                               required="required">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label>
                                            {l s='Numer Lokalu'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[flat_no]"
                                               id="receiver_flat_no" maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getFlatNo()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Kod pocztowy'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[postcode]"
                                               id="receiver_postcode" maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getPostcode()}"
                                               required="required">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Miasto'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[city]" id="receiver_city"
                                               maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getCity()}"
                                               required="required">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Kraj'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <select name="receiver[country]" id="receiver_country" class="polkurier_select2"
                                                style="width: 100%">
                                            <option value="">---</option>
                                            {foreach from=$countries item=item}
                                                <option value="{$item['iso']}" {if $item['id'] == $shipmentmodel->getReceiver()->getCountryId()} selected="selected" {/if}>{$item['name']}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label class="required">
                                            {l s='Telefon'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[phone]"
                                               id="receiver_phone" maxlength="35"
                                               value="{$shipmentmodel->getReceiver()->getPhone()}">
                                    </div>
                                </div>

                                <div class="row form-group mt-1">
                                    <div class="col-lg-4 text-right">
                                        <label>
                                            {l s='E-mail'}:
                                        </label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input type="text" class="form-control" name="receiver[email]"
                                               id="receiver_email" maxlength="50"
                                               value="{$shipmentmodel->getReceiver()->getEmail()}"
                                               required="required">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row form-group">
                            <div class="col-lg-2 text-right">
                                <label class="required">
                                    {l s='Opis zawartości'}<br>(max. 35 znaków):
                                </label>
                            </div>
                            <div class="col-lg-4">
                                <input type="text" class="form-control" name="polkurier_order_content"
                                       id="polkurier_order_content" maxlength="35" size="40"
                                       value="{$shipmentmodel->getOrderContent()}">
                            </div>
                        </div>

                        <hr>

                        <div class="row form-group">
                            <div class="col-lg-2 text-right">
                                <label>
                                    {l s='Pobranie'}:
                                </label>
                            </div>
                            <div class="col-lg-2">
                                <div class="input-group">
                                    <div class="input-group">
                                        <input type="text" class="form-control filter-float pack-param"
                                               name="polkurier_cod_order" id="polkurier_cod_order"
                                               value='{$shipmentmodel->getCodShipment()->getValue()}'
                                               autocomplete="off"/>
                                        <div class="input-group-addon input-group-append">
                                            <div class="input-group-text">
                                                PLN
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row form-group mt-3">
                            <div class="col-lg-2 text-right">
                                <label>
                                    {l s='Rodzaj zwrotu pobrania'}:
                                </label>
                            </div>
                            <div class="col-lg-6">
                                {foreach from=$codtype item=codname key=keycod}
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <input type="radio" id="polkurier_return_cod_type_{$keycod}"
                                                   name="polkurier_return_cod_type" class="pack-param"
                                                   value="{$keycod}" {if $shipmentmodel->getCodShipment()->getType() == $keycod} checked="checked" {/if}>
                                            <label for="polkurier_return_cod_type_{$keycod}">
                                                {l s=$codname}
                                            </label>
                                        </div>
                                    </div>
                                {/foreach}
                            </div>
                        </div>

                        <div class="row form-group mt-3">
                            <div class="col-lg-2 text-right">
                                <label>
                                    {l s='Konto pobraniowe'}:
                                </label>
                            </div>
                            <div class="col-lg-4">
                                <select name="polkurier_sender_bank_id" id="polkurier_sender_bank_id"
                                        class="form-control">
                                    {foreach from=$bank_list item=bank}
                                        <option value="{$bank.bank_id}" {if $bank.bank_id == $shipmentmodel->getCodShipment()->getIdCod()} selected="selected" {/if}>{$bank['name']}
                                            - {$bank['iban']}
                                        </option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div class="row form-group mt-3">
                            <div class="col-lg-2 text-right">
                                <label>
                                    {l s='Zwrot pobrania'}:
                                </label>
                            </div>
                            {assign var=cod_shipment_time value=$shipmentmodel->getCodShipment()->getTime()}
                            {if $cod_shipment_time == ''}{assign var=cod_shipment_time value=$cod_return_time_default}{/if}
                            <div class="col-lg-6">
                                {foreach from=$cod_return_time item=return_time_name key=return_time_key}
                                    <div class="row row-margin-bottom">
                                        <div class="col-lg-8">
                                            <input type="radio"
                                                   id="polkurier_return_cod_time_{$return_time_key}"
                                                   name="polkurier_return_cod_time"
                                                   class="pack-param"
                                                   value="{$return_time_key}"
                                                    {if $return_time_key == $cod_shipment_time} checked="checked" {/if}>
                                            {$return_time_name}
                                        </div>
                                    </div>
                                {/foreach}
                            </div>
                        </div>

                        <hr>

                        <div class="row form-group">
                            <div class="col-lg-2 text-right">
                                <label>
                                    {l s='Ubezpieczenie'}:
                                </label>
                            </div>
                            <div class="col-lg-2">
                                <div class="input-group money-type">
                                    <div class="input-group">
                                        <input type="text" class="form-control filter-float pack-param"
                                               name="polkurier_insurance_value" id="polkurier_insurance_value"
                                               value='{$shipmentmodel->getInsuranceValue()}' autocomplete="off"/>
                                        <div class="input-group-addon input-group-append">
                                            <div class="input-group-text">
                                                PLN
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row form-group">
                            <div class="col-lg-2 text-right">
                                <label>
                                    {l s='Usługi dodatkowe'}:
                                </label>
                            </div>
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <input type="checkbox"
                                               name="polkurier_order_service[sms_notification_recipient]"
                                               class="pack-param"
                                               value="1" {if $polkurier_order_sms_notification == 1} checked {/if}> {l s='Powiadomienie SMS dla odbiorcy'}
                                    </div>

                                    <div class="col-lg-6">
                                        <input type="checkbox" name="polkurier_order_service[printed_label]"
                                               class="pack-param"
                                               value="1"> {l s='Podjazd kurier z wydrukowaną etykietą'}
                                    </div>

                                    <div class="col-lg-6">
                                        <input type="checkbox" name="polkurier_order_service[week_collection]"
                                               class="pack-param"
                                               value="1"> {l s='Dostawa weekendowa (tylko InPost Paczkomaty)'}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row form-group">
                            <div class="col-lg-2 text-right">
                                <label class="required">
                                    {l s='Typ przesyłki'}:
                                </label>
                            </div>
                            <div class="col-lg-10">
                                <div class="row">
                                    {foreach from=$shipment_type item=item_type}
                                        <div class="col-lg-2">
                                            <input type="radio" id="polkurier_shipment_type_{$item_type.id}"
                                                   name="polkurier_shipment_type" class="pack-param"
                                                   value="{$item_type.id}" {if $shipmentmodel->getShipmentType() == $item_type.id OR ($shipmentmodel->getShipmentType() == '' AND $item_type.default == true)} checked="checked" {/if}>
                                            <label for="polkurier_shipment_type_{$item_type.id}">
                                                {$item_type.name}
                                            </label>
                                        </div>
                                    {/foreach}
                                </div>
                            </div>
                        </div>

                        <div class="row form-group">
                            <div class="col-lg-2 text-right">
                                <label for="pk_parcel_collection_template_id">
                                    {l s='Szablon Paczki'}:
                                </label>
                            </div>
                            <div class="col-lg-4">
                                <select id="polkurier_parcel_collection_template" class="polkurier_select2"
                                        style="width: 100%">
                                    <option value="">...</option>
                                    {foreach from=$parcel_template_list item=parcel}
                                        <option value="{$parcel['id']}">
                                            {$parcel['name']}
                                        </option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div class="row form-group">
                            <div class="col-lg-12 text-right">
                                <input type="button" id="add-pack-parameters-row" class="btn btn-primary"
                                       value="{l s='dodaj paczkę'}">
                            </div>
                        </div>

                        <div id="polkurier_block_packs_parameters">
                            <div class="row">
                                <div class="col-lg-2">
                                    <label class="required">{l s='długość'}</label>
                                </div>
                                <div class="col-lg-2">
                                    <label class="required">{l s='szerokość'}</label>
                                </div>
                                <div class="col-lg-2">
                                    <label class="required">{l s='wysokość'}</label>
                                </div>
                                <div class="col-lg-2">
                                    <label class="required">{l s='waga'}</label>
                                </div>
                                <div class="col-lg-1">
                                    <label class="required">{l s='ilość'}</label>
                                </div>
                                <div class="col-lg-2">
                                    <label>{l s='Niestandardowy kształt'}</label>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row">

                            <div class="col-lg-12">
                                <div class="row" id="valuation_error" style="display: none">
                                    <div class="col-lg-12">
                                        <div class="module_error alert alert-danger">
                                            <span id="valuation_error_string"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6 text-center" id="valuation_submit_loading"></div>
                                    <div class="col-lg-6 text-right">
                                        <input type="button" id="polkurier_order_valuation_submit"
                                               class="btn btn-primary" value="{l s='Wyceń'}">
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-lg-12">
                                        {foreach from=$couriers item=row}
                                            <div class="company-button-container-valuation"
                                                 data-servicecode="{$row['id']}" id="service_code_{$row['id']}">
                                                <div class="container-carrier-valuation company-button-valuation">
                                                    <div class="courierfullinfo">{$row['name']}</div>
                                                    <div class="carrier-text-valuation">
                                            <span class="carrier-price-valuation">
                                                NETTO
                                                <span id="valuation_{$row['id']}_netto"
                                                      class="valuation_value">0.00</span> PLN</span>
                                                        <div></div>
                                                        <span class="carrier-price-valuation">
                                                            BRUTTO
                                                            <span id="valuation_{$row['id']}_brutto"
                                                                  class="valuation_value">0.00</span> PLN</span>
                                                    </div>
                                                </div>
                                            </div>
                                        {/foreach}
                                    </div>
                                </div>
                            </div>

                        </div>

                        <hr>

                        <div class="row form-group">
                            <div class="col-lg-12">
                                {l s='Nadanie przesyłki'}: <span id="pickup_time_loader"></span>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-lg-1 text-center">
                                <input type="radio" id="polkurier_pickup_type_COURIER" name="polkurier_pickup_type"
                                       class="polkurier_pickup_type"
                                       value="COURIER" {if $default_pickup_type == "COURIER"} checked="checked" {/if}>
                            </div>
                            <div class="col-lg-11">
                                {l s='Zamawiam odbiór przesyłek'}
                            </div>
                        </div>

                        <div class="row form-group">
                            <div class="col-lg-10 text-center" style="font-weight:bold;"
                                 id="polkurier_pickup_info_content"></div>
                        </div>

                        <div class="row">
                            <div class="col-lg-1"></div>
                            <div class="col-lg-3">
                                <label for="polkurier_date_pickup">
                                    {l s='Data'}: <span id="date_pickup_ico"></span>
                                </label>
                                <select id="polkurier_date_pickup" name="polkurier_date_pickup" class="custom-select">
                                    {foreach from=$date_pickup_array item=item}
                                        <option value="{$item}">
                                            {$item}
                                        </option>
                                    {/foreach}
                                </select>
                            </div>
                            <div class="col-lg-2">
                                <label for="polkurier_time_pickup" class="polkurier_time_pickup_grup">
                                    {l s='Godzina'}:
                                </label>
                                <select id="polkurier_time_pickup" name="polkurier_time_pickup"
                                        class="custom-select polkurier_time_pickup_grup"></select>
                            </div>
                        </div>

                        <div class="row form-group">
                            <div class="col-lg-1 text-center">
                                <input type="radio" id="polkurier_pickup_type_SELF" name="polkurier_pickup_type"
                                       class="polkurier_pickup_type"
                                       value="SELF" {if $default_pickup_type == "SELF"} checked="checked" {/if}>
                            </div>
                            <div class="col-lg-11">
                                {l s='Zamówię kuriera samodzielnie przez telefon/lub dostarczę do punktu nadania'}
                            </div>
                        </div>


                        <div class="row" id="polkurier_order_submit_error" style="display: none;">
                            <div class="col-lg-12">
                                <div class="module_error alert alert-danger">
                                    <span id="polkurier_order_submit_error_string"></span>
                                </div>
                            </div>
                        </div>

                        <div class="row form-group mt-5">
                            <div class="col-lg-12 text-center">
                                <input type="submit" id="polkurier_order_submit" name="polkurier_order_submit"
                                       class="btn btn-primary"
                                       value="{l s='Zamów kuriera według powyższych danych'}"/>
                                <div id="order_submit_info" class="text-center row-margin-top row-margin-bottom"></div>
                            </div>
                        </div>
                        <input type="hidden" value="" name="poklurier_service_code" id="poklurier_service_code">
                    </form>
                </div>
            </div>
        </div>
    </div>
{literal}
    <script type="text/javascript">

        const POLKURIER_MODULE_TOKEN = '{/literal}{$polkurier_token}{literal}';
        const POLKURIER_URL_MODULES_AJAX = '{/literal}{$POLKURIER_URL_MODULES_AJAX}{literal}';
        let POLKURIER_PARCEL_COLLECTION_COUNT = 0;
        const POLKURIER_TEMPLATE_PACK_JSON = {/literal}{$parcel_template_list_json|default:'{}'};{literal}
        const POLKURIER_TEMPLATE_SENDER_JSON = {/literal}{$sender_list_json|default:'{}'};{literal}
        var POLKURIER_CURENT_SERVICE_CODE = "{/literal}{$shipmentmodel->getServiceCode()}{literal}";
        let POLKURIER_IS_LOCKED = false;
        const RECEIVER_COLLECTION_POINT = "{/literal}{$shipmentmodel->getReceiver()->getStation()}{literal}";
        const POLKURIER_SENDER_POINT_INPOST_PACZKOMAT = "{/literal}{$polkurier_sender_point_inpost_paczkomat}{literal}";
        const POLKURIER_SENDER_POINT_POCZTEX = "{/literal}{$polkurier_sender_point_pocztex_punkt}{literal}";
        const POLKURIER_SENDER_POINT_DPD = "{/literal}{$polkurier_sender_point_dpd}{literal}";
        const POLKURIER_SENDER_POINT_UPS = "{/literal}{$polkurier_sender_point_ups}{literal}";

        var PolkurierOrderJs = {
            SetTemplateSender: function (idtemplate) {
                if (POLKURIER_TEMPLATE_SENDER_JSON[idtemplate] === undefined) {
                    return false;
                }
                jQuery('#sender_company').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].company);
                jQuery('#sender_firstname').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].first_name);
                jQuery('#sender_lastname').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].last_name);
                jQuery('#sender_street').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].street);
                jQuery('#sender_house_no').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].house_no);
                jQuery('#sender_flat_no').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].flat_no);
                jQuery('#sender_postcode').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].postcode);
                jQuery('#sender_city').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].city);
                jQuery('#sender_contact_name').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].contact_name);
                jQuery('#sender_phone').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].phone);
                jQuery('#sender_email').val(POLKURIER_TEMPLATE_SENDER_JSON[idtemplate].email);

                this.pickup_time();
            },

            SetTemplatePack: function (idtemplate) {

                if (POLKURIER_TEMPLATE_PACK_JSON[idtemplate] === undefined) {
                    return false;
                }

                const lastpackcontainer = jQuery(".pack-parameters-container:last");
                lastpackcontainer.find('.pack-length').val(POLKURIER_TEMPLATE_PACK_JSON[idtemplate].dim_1);
                lastpackcontainer.find('.pack-width').val(POLKURIER_TEMPLATE_PACK_JSON[idtemplate].dim_2);
                lastpackcontainer.find('.pack-height').val(POLKURIER_TEMPLATE_PACK_JSON[idtemplate].dim_3);
                lastpackcontainer.find('.pack-weight').val(POLKURIER_TEMPLATE_PACK_JSON[idtemplate].weight);
                lastpackcontainer.find('.pack-amount').val(POLKURIER_TEMPLATE_PACK_JSON[idtemplate].quantity);

                if (POLKURIER_TEMPLATE_PACK_JSON[idtemplate].content.length > 0) {
                    jQuery('#polkurier_order_content').val(POLKURIER_TEMPLATE_PACK_JSON[idtemplate].content);
                }

                if (POLKURIER_TEMPLATE_PACK_JSON[idtemplate].shipment_type.length > 0) {
                    jQuery('input[name="polkurier_shipment_type"]').prop('checked', false);
                    jQuery('#polkurier_shipment_type_' + POLKURIER_TEMPLATE_PACK_JSON[idtemplate].shipment_type).prop('checked', true);
                }
                lastpackcontainer.find('.pack-custom option[value="' + POLKURIER_TEMPLATE_PACK_JSON[idtemplate].nstd + '"]').attr("selected", true).change();
            },

            filterFloat: function (value) {
                return String(value).replace(',', '.').replace(/[^0-9.]/g, '');
            },

            filterInt: function (value) {
                return String(value).replace(/[^0-9]/g, '');
            },

            addCountPack: function () {
                return POLKURIER_PARCEL_COLLECTION_COUNT++;
            },

            removeRow: function (domNode) {
                jQuery(domNode).parents('.pack-parameters-container').remove();
                if (jQuery('.pack-parameters-container').length === 0) {
                    this.addRowPack();
                }
            },

            addRowPack: function () {
                const count_pack = this.addCountPack();
                jQuery('#polkurier_block_packs_parameters').append(this.row_pack_html(count_pack));
                this.ValidateAllPacks();
                return count_pack;
            },

            RowParamsValidator: function (domNode) {

                const rowContainer = jQuery(domNode);
                let invalidFields = [];
                const length = rowContainer.find('.pack-length');
                const width = rowContainer.find('.pack-width');
                const height = rowContainer.find('.pack-height');
                const weight = rowContainer.find('.pack-weight');
                const amount = rowContainer.find('.pack-amount');

                length.parents('.input-group').removeClass('has-error');
                width.parents('.input-group').removeClass('has-error');
                height.parents('.input-group').removeClass('has-error');
                weight.parents('.input-group').removeClass('has-error');
                amount.parents('.input-group').removeClass('has-error');


                invalidFields = [];
                const floatTest = /^[0-9\.]+$/;
                const intTest = /^[0-9]+$/;

                if (!floatTest.test(this.filterFloat(length.val())) || this.filterFloat(length.val()) === 0) {
                    invalidFields.push(length);
                }
                if (!floatTest.test(this.filterFloat(width.val())) || this.filterFloat(width.val()) === 0) {
                    invalidFields.push(width);
                }
                if (!floatTest.test(this.filterFloat(height.val())) || this.filterFloat(height.val()) === 0) {
                    invalidFields.push(height);
                }
                if (!floatTest.test(this.filterFloat(weight.val())) || this.filterFloat(weight.val()) === 0) {
                    invalidFields.push(weight);
                }
                if (!intTest.test(this.filterFloat(amount.val())) || this.filterFloat(amount.val()) === 0) {
                    invalidFields.push(amount);
                }

                if (invalidFields.length === 0) {
                    return true;
                }

                if (invalidFields.length === 5) {
                    return false;
                }

                for (var x in invalidFields) {
                    if (!invalidFields.hasOwnProperty(x)) {
                        continue;
                    }
                    invalidFields[x].parents('.input-group').addClass('has-error');
                }
            },

            ValidateAllPacks: function () {
                let valid = true;
                const _self = this;
                jQuery('.pack-parameters-container').each(function () {
                    if (!_self.RowParamsValidator(this)) {
                        valid = false;
                    }
                });
                return valid;
            },

            Calculate: function () {

                const valuation_error = jQuery('#valuation_error');
                const company_button_container_valuation = jQuery(".company-button-container-valuation");
                const valuation_submit_loading = jQuery('#valuation_submit_loading');
                valuation_error.hide();
                jQuery('.valuation_value').html('0.00');
                if (!this.ValidateAllPacks()) {
                    return false;
                }

                valuation_submit_loading.html('Proszę czekać, trwa wycena <img src="../img/loader.gif" alt="" border="0" />');
                var data = jQuery('#polkurier_order_form').serialize();
                jQuery.ajax({
                    url: POLKURIER_URL_MODULES_AJAX,
                    type: "POST",
                    dataType: 'json',
                    data: {
                        'data_form': data,
                        'action': 'valuationorder',
                        'ajax': true,
                        'token': POLKURIER_MODULE_TOKEN,
                        'controller': 'AdminPolkurierModule'
                    },
                    success: function (result) {
                        if (result) {
                            if (result.status === true) {
                                if (result.data.length) {
                                    company_button_container_valuation.hide();
                                    jQuery.each(result.data, function (key, item) {
                                        jQuery('#valuation_' + item.servicecode + '_netto').html(item.netprice.toFixed(2));
                                        jQuery('#valuation_' + item.servicecode + '_brutto').html(item.grossprice.toFixed(2));
                                        if (item.shipment === true) {
                                            jQuery("#service_code_" + item.servicecode).show();
                                        } else {
                                            jQuery("#service_code_" + item.servicecode).hide();
                                            if (item.servicecode === PolkurierOrderJs.getServiceCode()) {
                                                PolkurierOrderJs.setServiceCode('');
                                            }
                                        }
                                    });
                                }
                            } else {
                                PolkurierOrderJs.setServiceCode('');
                                company_button_container_valuation.show();
                                valuation_error.show();
                                jQuery('#valuation_error_string').html(result.error);
                            }
                        }
                    },
                    error: function (error) {
                        console.log(error);
                    }
                }).done(function () {
                    valuation_submit_loading.html('ZAKOŃCZONO PRZELICZANIE CEN');
                    setTimeout(function () {
                        valuation_submit_loading.empty();
                    }, 2000);
                });
            },

            NewOrder: function () {

                const polkurier_order_submit_error = jQuery('#polkurier_order_submit_error');
                const polkurier_order_submit_error_string = jQuery('#polkurier_order_submit_error_string');
                const order_submit_info = jQuery('#order_submit_info');
                var lt = jQuery('#polkurier_show_hide_form').data('token');

                polkurier_order_submit_error.hide();

                if (!this.ValidateAllPacks()) {
                    polkurier_order_submit_error.show();
                    polkurier_order_submit_error_string.html('Brak lub nieprawidłowe wymiary przesyłki');
                    return false;
                }

                if (!jQuery("#poklurier_service_code").val()) {
                    polkurier_order_submit_error.show();
                    polkurier_order_submit_error_string.html('Brak wybranego przewoźnika');
                    return false;
                }

                POLKURIER_IS_LOCKED = true;
                order_submit_info.html('Proszę czekać, trwa składanie zlecenia <img src="../img/loader.gif" alt="" border="0" />');
                const data = jQuery('#polkurier_order_form').serialize();

                jQuery.ajax({
                    url: POLKURIER_URL_MODULES_AJAX,
                    type: "POST",
                    dataType: 'json',
                    data: {
                        'data_form': data,
                        'action': 'order',
                        'ajax': true,
                        'token': POLKURIER_MODULE_TOKEN,
                        'controller': 'AdminPolkurierModule'
                    },
                    success: function (result) {
                        if (result) {
                            if (result.status === true) {
                                PolkurierOrderJs.new_order_end(result.data.idorder, result.data.order_number, lt);
                            } else {
                                polkurier_order_submit_error.show();
                                polkurier_order_submit_error_string.html(result.error);
                            }
                        }
                    },
                    error: function (error) {
                        console.log(error);
                    }
                }).done(function () {
                    POLKURIER_IS_LOCKED = false;
                    order_submit_info.empty();
                });
            },

            new_order_end: function (idorder, number_order, lt) {

                const html = '<div class="row row-margin-bottom">\n' +
                    '                        <div class="col-lg-12 text-center">\n' +
                    '                            <h1>Dziękujemy za złożenie zamówienia.</h1>\n' +
                    '                        </div>\n' +
                    '                    </div>\n' +
                    '                    <div class="row row-margin-bottom">\n' +
                    '                        <div class="col-lg-12 text-center">\n' +
                    '                            <h2>NUMER ZLECENIA: ' + number_order + '</h2>\n' +
                    '                        </div>\n' +
                    '                    </div>\n' +
                    '\n' +
                    '                    <div class="row">\n' +
                    '                        <div class="col-lg-6 text-center">\n' +
                    '                            <a rel="new-window" class="dwonloadLabelButton" data-token="'+lt+'" href="javascript:DownloadLabel(' + idorder + ')">\n' +
                    '                                <button type="button" class="btn btn-primary btn-md">\n' +
                    '                                    POBIERZ LIST PRZEWOZOWY\n' +
                    '                                </button>\n' +
                    '                            </a>\n' +
                    '                        </div>\n' +
                    '                        <div class="col-lg-6 text-center">\n' +
                    '                            <a rel="new-window" class="dwonloadProtocolButton" data-token="'+lt+'"  href="javascript:DownloadProtocol(' + idorder + ')">\n' +
                    '                                <button type="button" class="btn btn-primary btn-md">\n' +
                    '                                    PROTOKÓŁ DLA NADAWCY\n' +
                    '                                </button>\n' +
                    '                            </a>\n' +
                    '                        </div>\n' +
                    '                    </div>';

                const polkurier_order_form_div = jQuery('#polkurier_order_form_div');
                polkurier_order_form_div.empty();
                polkurier_order_form_div.html(html);
                jQuery("html, body").delay(500).animate({
                    scrollTop: polkurier_order_form_div.offset().top - 250
                }, 500);
            },

            pickup_time: function () {
                const date_pickup_ico = jQuery('#date_pickup_ico');
                const polkurier_pickup_info_content = jQuery('#polkurier_pickup_info_content');
                const polkurier_time_pickup_grup = jQuery('.polkurier_time_pickup_grup');
                const pickup_time_loader = jQuery('#pickup_time_loader');

                date_pickup_ico.empty();
                polkurier_pickup_info_content.empty();

                if (jQuery('#polkurier_date_pickup option:selected').val() == '' || jQuery('#sender_postcode').val() == '' || this.getServiceCode() == '') {
                    return;
                }
                pickup_time_loader.html('<img src="../img/loader.gif" alt="" border="0" />');
                jQuery.ajax({
                    url: POLKURIER_URL_MODULES_AJAX,
                    type: "GET",
                    dataType: 'json',
                    data: {
                        'pickup_date': jQuery('#polkurier_date_pickup option:selected').val(),
                        'postal_code': jQuery('#sender_postcode').val(),
                        'parcel': jQuery('input[name=polkurier_shipment_type]:checked').val(),
                        'service_code': PolkurierOrderJs.getServiceCode(),
                        'action': 'pickup',
                        'ajax': true,
                        'token': POLKURIER_MODULE_TOKEN,
                        'controller': 'AdminPolkurierModule'
                    },
                    success: function (result) {
                        const select = jQuery('#polkurier_time_pickup');
                        polkurier_time_pickup_grup.show();
                        select.empty();
                        date_pickup_ico.empty();
                        if (result) {
                            if (result.status == true) {
                                polkurier_pickup_info_content.empty();
                                if (result.data.pickupdate == true) {
                                    date_pickup_ico.html('<i class="icon-ok-circle" style="color: green"></i>');
                                } else {
                                    date_pickup_ico.html('<i class="icon-remove" style="color: red"></i>');
                                }
                                if (result.data.time.length && result.data.pickupdate == true) {
                                    jQuery.each(result.data.time, function (key, value) {
                                        select.append(jQuery('<option/>').val(value.timefrom + '|' + value.timeto).text(value.timefrom + ' - ' + value.timeto));
                                    });
                                } else {
                                    polkurier_time_pickup_grup.hide();
                                }
                            } else {
                                date_pickup_ico.html('<i class="icon-remove" style="color: red"></i>');
                                polkurier_pickup_info_content.html(result.error);
                            }
                        }
                    },
                    error: function (error) {
                        console.log(error);
                    }
                }).done(function () {
                    pickup_time_loader.empty();
                });
            },

            row_pack_html: function (counter) {
                return '<div class="row form-group pack-parameters-container mt-2">\n' +
                    '            <div class="col-lg-2">\n' +
                    '                <div class="input-group">\n' +
                    '                    <input class="form-control parcel_size pack-length filter-float pack-param" required="required" name="polkuier_parcel_collection[' + counter + '][dim_1]"\n' +
                    '                           id="polkuier_parcel_collection_' + counter + '_dim_1" type="text" autocomplete="off" value="">\n' +
                    '                          <div class="input-group-addon input-group-append"><div class="input-group-text">cm</div></div>\n' +
                    '                </div>\n' +
                    '            </div>\n' +
                    '\n' +
                    '            <div class="col-lg-2">\n' +
                    '                <div class="input-group">\n' +
                    '                    <input class="form-control parcel_size pack-width filter-float pack-param" required="required" name="polkuier_parcel_collection[' + counter + '][dim_2]"\n' +
                    '                           id="polkuier_parcel_collection_' + counter + '_dim_2" type="text" autocomplete="off" value="">\n' +
                    '                    <div class="input-group-addon input-group-append"><div class="input-group-text">cm</div></div>\n' +
                    '                </div>\n' +
                    '            </div>\n' +
                    '\n' +
                    '            <div class="col-lg-2">\n' +
                    '                <div class="input-group">\n' +
                    '                    <input class="form-control parcel_size pack-height filter-float pack-param" required="required" name="polkuier_parcel_collection[' + counter + '][dim_3]"\n' +
                    '                           id="polkuier_parcel_collection_' + counter + '_dim_3" type="text" autocomplete="off" value="">\n' +
                    '                    <div class="input-group-addon input-group-append"><div class="input-group-text">cm</div></div>\n' +
                    '                </div>\n' +
                    '            </div>\n' +
                    '\n' +
                    '            <div class="col-lg-2">\n' +
                    '                <div class="input-group">\n' +
                    '                    <input class="form-control parcel_size pack-weight filter-float pack-param" required="required" name="polkuier_parcel_collection[' + counter + '][weight]"\n' +
                    '                           id="polkuier_parcel_collection_' + counter + '_weight" type="text" autocomplete="off" value="">\n' +
                    '                    <div class="input-group-addon input-group-append"><div class="input-group-text">kg</div></div>\n' +
                    '                </div>\n' +
                    '            </div>\n' +
                    '\n' +
                    '            <div class="col-lg-1">\n' +
                    '                <div class="input-group">\n' +
                    '                    <input class="form-control parcel_size pack-amount filter-int pack-param" required="required" name="polkuier_parcel_collection[' + counter + '][quantity]"\n' +
                    '                           id="polkuier_parcel_collection_' + counter + '_quantity" type="text" autocomplete="off" value="1">\n' +
                    '                    <div class="input-group-addon input-group-append"><div class="input-group-text">szt.</div></div>\n' +
                    '                </div>\n' +
                    '            </div>\n' +
                    '\n' +
                    '            <div class="col-lg-2">\n' +
                    '                <select name="polkuier_parcel_collection[' + counter + '][no_std]" id="polkuier_parcel_collection_' + counter + '_no_std" class="custom-select pack-custom pack-param">\n' +
                    '                    <option value="0">NIE</option>\n' +
                    '                    <option value="1">TAK</option>\n' +
                    '                </select>\n' +
                    '            </div>\n' +
                    '\n' +
                    '            <div class="col-lg-1">\n' +
                    '                <input type="button" class="btn btn-primary remove_pack_row" value="Usuń">\n' +
                    '            </div>\n' +
                    '</div>';
            },

            setRemoveActiveServiceCode: function () {
                jQuery('.company-button-container-valuation').removeClass('active');
            },

            setActiveServiceCode: function (service_code) {
                this.setRemoveActiveServiceCode();
                if (service_code) {
                    jQuery('#service_code_' + service_code).addClass('active');
                }
            },

            ChangeServiceCode: function (service_code) {
                this.setServiceCode(service_code);
                PolkurierCollectionPoint.ChangeCollectionPoint();
                PolkurierOrderJs.pickup_time();
            },

            setServiceCode: function (service_code) {
                POLKURIER_CURENT_SERVICE_CODE = service_code;
                jQuery('#poklurier_service_code').val(service_code);
                this.setActiveServiceCode(service_code);
            },

            getServiceCode: function () {
                return POLKURIER_CURENT_SERVICE_CODE;
            },
        };

        var PolkurierCollectionPoint = {
            ChangeCollectionPoint: function () {

                const pk_station_list_box = jQuery('.pk_station_list_box');
                const pk_station_list_box_sender = jQuery('#pk_station_list_box_sender');
                const pk_station_list_box_receiver = jQuery('#pk_station_list_box_receiver');

                pk_station_list_box.hide();
                var servicecode = PolkurierOrderJs.getServiceCode();
                if (servicecode === 'INPOST_PACZKOMAT' || servicecode === 'INPOST_PACZKOMAT_ECONOMY') {

                    pk_station_list_box.show();
                    this.setSelectSenderPoint({
                        'couriers': ['INPOST_PACZKOMAT'],
                        'searchquery': POLKURIER_SENDER_POINT_INPOST_PACZKOMAT
                    });
                    this.setSelectReceiverPoint({'couriers': ['INPOST_PACZKOMAT']});
                    this.setSelfPickup();

                } else if (servicecode === 'POCZTEX_PUNKT') {

                    pk_station_list_box_sender.show();
                    this.setSelectSenderPoint({
                        'couriers': ['POCZTEX_PUNKT'],
                        'searchquery': POLKURIER_SENDER_POINT_POCZTEX
                    });
                    this.setSelfPickup();

                } else if (servicecode === 'POCZTEX_PUNKT_PUNKT') {

                    pk_station_list_box.show();

                    this.setSelectSenderPoint({
                        'couriers': ['POCZTEX_PUNKT'],
                        'searchquery': POLKURIER_SENDER_POINT_POCZTEX
                    });
                    this.setSelectReceiverPoint({
                        'couriers': ['POCZTEX_PUNKT']
                    });
                    this.setSelfPickup();

                } else if (servicecode === 'POCZTEX_KURIER_PUNKT') {

                    pk_station_list_box_receiver.show();
                    this.setSelectReceiverPoint({
                        'couriers': ['POCZTEX_PUNKT']
                    });

                } else if (servicecode === 'PACZKA_W_RUCHU') {

                    pk_station_list_box_receiver.show();
                    this.setSelectReceiverPoint({
                        'couriers': ['PACZKA_W_RUCHU']
                    });

                } else if (servicecode === 'INPOST_PACZKOMAT_KURIER') {

                    pk_station_list_box_sender.show();
                    this.setSelectSenderPoint({
                        'couriers': ['INPOST_PACZKOMAT'],
                        'searchquery': POLKURIER_SENDER_POINT_INPOST_PACZKOMAT
                    });

                } else if (servicecode === 'DPD_COURIER_POINT') {

                    pk_station_list_box_receiver.show();
                    this.setSelectReceiverPoint({
                        'couriers': ['DPD_POINT']
                    });

                } else if (servicecode === 'DPD_POINT') {

                    pk_station_list_box.show();
                    this.setSelectSenderPoint({
                        'couriers': ['DPD_POINT'],
                        'searchquery': POLKURIER_SENDER_POINT_DPD
                    });
                    this.setSelectReceiverPoint({
                        'couriers': ['DPD_POINT']
                    });
                    this.setSelfPickup();

                } else if (servicecode === 'FEDEX_DTR') {

                    pk_station_list_box_receiver.show();
                    this.setSelectReceiverPoint({
                        'couriers': ['FEDEX_DTR']
                    });

                } else if (servicecode === 'DHL_POINT') {

                    pk_station_list_box_receiver.show();
                    this.setSelectReceiverPoint({
                        'couriers': ['DHL_POINT']
                    });

                } else if (servicecode === 'UPS_AP_POINT_COURIER') {

                    pk_station_list_box_sender.show();
                    this.setSelectSenderPoint({
                        'couriers': ['UPS_AP_POINT_POINT'],
                        'searchquery': POLKURIER_SENDER_POINT_UPS
                    });

                } else if (servicecode === 'UPS_AP_POINT_POINT') {

                    pk_station_list_box.show();
                    this.setSelectSenderPoint({
                        'couriers': ['UPS_AP_POINT_POINT'],
                        'searchquery': POLKURIER_SENDER_POINT_UPS
                    });
                    this.setSelectReceiverPoint({
                        'couriers': ['UPS_AP_POINT_POINT']
                    });

                } else if (servicecode === 'UPS_AP_COURIER_POINT') {

                    pk_station_list_box_receiver.show();
                    this.setSelectReceiverPoint({
                        'couriers': ['UPS_AP_POINT_POINT']
                    });
                } else if (servicecode === 'INPOST_INTERNATIONAL') {

                    pk_station_list_box.show();
                    this.setSelectSenderPoint({
                        'couriers': ['INPOST_INTERNATIONAL'],
                        'searchquery': POLKURIER_SENDER_POINT_INPOST_PACZKOMAT
                    });
                    this.setSelectReceiverPoint({
                        'couriers': ['INPOST_INTERNATIONAL'],
                        'country': jQuery('#receiver_country').val()
                    });
                    this.setSelfPickup();
                }
            },

            setSelectSenderPoint: function (options) {
                options = options || {};
                const props = {
                    'select': 'polkurier_sender_station',
                    'functions': ['send'],
                    'couriers': options.couriers || '',
                    'searchquery': options.searchquery || ''
                };
                this.LoadCourierPoint(props);
            },

            setSelectReceiverPoint: function (options) {
                options = options || {};
                var functions = [];
                functions.push('collect');
                if (jQuery('#polkurier_cod_order').val() > 0) {
                    functions.push('cod');
                }

                const props = {
                    'select': 'polkurier_receiver_station',
                    'functions': functions,
                    'couriers': options.couriers || '',
                    'searchquery': RECEIVER_COLLECTION_POINT
                };
                this.LoadCourierPoint(props);
            },

            setSelfPickup: function () {
                jQuery('input:radio[name=polkurier_pickup_type][value=SELF]').prop('checked', true).trigger('change');
            },

            LoadCourierPoint: function (options) {
                options = options || {};
                const props = {
                    'select': options.select,
                    'functions': options.functions || [],
                    'couriers': options.couriers || ['INPOST_PACZKOMAT'],
                    'searchquery': options.searchquery
                };

                const select = jQuery('#' + options.select);
                select.empty();
                select.select2("destroy");
                select.select2({
                    minimumInputLength: 3,
                    ajax: {
                        url: POLKURIER_URL_MODULES_AJAX,
                        dataType: 'json',
                        type: "POST",
                        quietMillis: 1000,
                        data: function (params) {
                            return {
                                'ajax': true,
                                'action': 'courierpoint',
                                'token': POLKURIER_MODULE_TOKEN,
                                'controller': 'AdminPolkurierModule',
                                'couriers': props.couriers,
                                'functions': props.functions,
                                'searchquery': params.term
                            };
                        },
                        processResults: function (result) {
                            return {
                                results: PolkurierCollectionPoint.PrepareResults(result)
                            };
                        },
                    },
                    placeholder: "wpisz nazwę punktu, kod pocztowy lub miasto",
                    allowClear: true,
                    width: 'resolve',
                    theme: "classic"
                });
                this.PreloadSelect2(select, props);
            },

            PrepareResults: function (result) {
                const myResults = [];
                if (result.status === true) {
                    if (result.data) {
                        jQuery.each(result.data, function (index, item) {
                            myResults.push({
                                'id': item.id,
                                'text': '[' + item.id + '] ' + item.street + ' ' + item.zip + ' ' + item.city
                            });
                        });
                    }
                }
                return myResults;
            },

            PreloadSelect2: function (select, options) {
                jQuery.ajax({
                    url: POLKURIER_URL_MODULES_AJAX,
                    type: "GET",
                    dataType: 'json',
                    data: {
                        'ajax': true,
                        'action': 'courierpoint',
                        'token': POLKURIER_MODULE_TOKEN,
                        'controller': 'AdminPolkurierModule',
                        'couriers': options.couriers,
                        'functions': options.functions,
                        'searchquery': options.searchquery
                    },
                    success: function (result) {
                        const items = PolkurierCollectionPoint.PrepareResults(result);
                        jQuery.each(items, function (index, item) {
                            const newOption = new Option(item.text, item.id, false, false);
                            select.append(newOption).trigger('change');
                        });
                    }
                });
            },

            ShowCourierPointMap: function (target) {

                var servicecode = PolkurierOrderJs.getServiceCode();

                if (servicecode === 'INPOST_PACZKOMAT' || servicecode === 'INPOST_PACZKOMAT_ECONOMY') {

                    if (target === 'sender') {
                        this.setPropsSenderPointMap({'providers': 'INPOST_PACZKOMAT'});
                    } else {
                        this.setPropsReceiverPointMap({'providers': 'INPOST_PACZKOMAT'});
                    }

                } else if (servicecode === 'POCZTEX_PUNKT') {

                    this.setPropsSenderPointMap({'providers': 'POCZTEX_PUNKT'});

                } else if (servicecode === 'POCZTEX_PUNKT_PUNKT') {

                    if (target === 'sender') {
                        this.setPropsSenderPointMap({'providers': 'POCZTEX_PUNKT'});
                    } else {
                        this.setPropsReceiverPointMap({'providers': 'POCZTEX_PUNKT'});
                    }

                } else if (servicecode === 'POCZTEX_KURIER_PUNKT') {

                    this.setPropsReceiverPointMap({'providers': 'POCZTEX_PUNKT'});

                } else if (servicecode === 'PACZKA_W_RUCHU') {

                    this.setPropsReceiverPointMap({'providers': 'PACZKA_W_RUCHU'});

                } else if (servicecode === 'INPOST_PACZKOMAT_KURIER') {

                    this.setPropsSenderPointMap({'providers': 'INPOST_PACZKOMAT'});

                } else if (servicecode === 'DPD_COURIER_POINT') {

                    this.setPropsReceiverPointMap({'providers': 'DPD_POINT'});

                } else if (servicecode === 'DPD_POINT') {

                    if (target === 'sender') {
                        this.setPropsSenderPointMap({'providers': 'DPD_POINT'});
                    } else {
                        this.setPropsReceiverPointMap({'providers': 'DPD_POINT'});
                    }

                } else if (servicecode === 'FEDEX_DTR') {

                    this.setPropsReceiverPointMap({'providers': 'FEDEX_DTR'});

                } else if (servicecode === 'DHL_POINT') {

                    this.setPropsReceiverPointMap({'providers': 'DHL_POINT'});

                } else if (servicecode === 'UPS_AP_POINT_COURIER') {

                    this.setPropsSenderPointMap({'providers': 'UPS_AP_POINT_POINT'});

                } else if (servicecode === 'UPS_AP_POINT_POINT') {

                    if (target === 'sender') {
                        this.setPropsSenderPointMap({'providers': 'UPS_AP_POINT_POINT'});
                    } else {
                        this.setPropsReceiverPointMap({'providers': 'UPS_AP_POINT_POINT'});
                    }

                } else if (servicecode === 'UPS_AP_COURIER_POINT') {

                    this.setPropsReceiverPointMap({'providers': 'UPS_AP_POINT_POINT'});

                } else if (servicecode === 'INPOST_INTERNATIONAL') {

                    if (target === 'sender') {
                        this.setPropsSenderPointMap({'providers': 'INPOST_INTERNATIONAL'});
                    } else {
                        this.setPropsReceiverPointMap({'providers': 'INPOST_INTERNATIONAL', 'country': 'IT'});
                    }
                }
            },

            setPropsSenderPointMap: function (options) {
                options = options || {};
                var props = {
                    'searchQuery': jQuery('#polkurier_sender_station').val() || jQuery('#sender_postcode').val(),
                    'providers': options.providers,
                    'functions': ['send'],
                    'input_chosen': 'polkurier_sender_station',
                };
                showPointsMap(props);
            },

            setPropsReceiverPointMap: function (options) {
                options = options || {};
                var functions = ['collect'];
                if (jQuery('#polkurier_cod_order').val() > 0) {
                    functions.push('cod');
                }
                var props = {
                    'searchQuery': jQuery('#polkurier_receiver_station').val() || RECEIVER_COLLECTION_POINT || jQuery('#receiver_postcode').val(),
                    'providers': options.providers,
                    'functions': functions,
                    'input_chosen': 'polkurier_receiver_station',
                    'country': options.country || ''
                };
                showPointsMap(props);
            }
        };

        jQuery('#add-pack-parameters-row').on('click', function () {
            PolkurierOrderJs.addRowPack();
        });

        jQuery(document).on('click', '.remove_pack_row', function () {
            PolkurierOrderJs.removeRow(this);
            PolkurierOrderJs.ValidateAllPacks();
            PolkurierOrderJs.Calculate();
        });

        jQuery('#polkurier_show_hide_form').on('click', function () {
            if (jQuery('#polkurier_order_form_div').is(":visible")) {
                jQuery('#polkurier_order_form_div').hide();
                jQuery(this).val('NADAJ PRZESYŁKĘ');

            } else {
                jQuery('#polkurier_order_form_div').show();
                jQuery(this).val('UKRYJ');
            }
        });

        jQuery(document).on('change', '.filter-float', function () {
            jQuery(this).val(PolkurierOrderJs.filterFloat(jQuery(this).val()));
        });

        jQuery(document).on('change', '.filter-int', function () {
            jQuery(this).val(PolkurierOrderJs.filterInt(jQuery(this).val()));
        });

        jQuery(document).on('change', '#polkurier_parcel_collection_template', function () {
            PolkurierOrderJs.SetTemplatePack(PolkurierOrderJs.filterInt(jQuery(this).val()));
            jQuery(this).prop('selectedIndex', 0);
        });

        jQuery(document).on('change', '#sender_tempalte_id', function () {
            PolkurierOrderJs.SetTemplateSender(PolkurierOrderJs.filterInt(jQuery(this).val()));
        });

        jQuery('#polkurier_order_valuation_submit').on('click', function (e) {
            e.preventDefault();
            PolkurierOrderJs.Calculate();
        });

        jQuery('#polkurier_order_submit').on('click', function (e) {
            e.preventDefault();
            if (POLKURIER_IS_LOCKED === false) {
                PolkurierOrderJs.NewOrder();
            }
        });

        jQuery('.company-button-container-valuation').on('click', function () {
            PolkurierOrderJs.ChangeServiceCode(jQuery(this).data('servicecode'));
        });

        jQuery(document).on('change', '#polkurier_parcel_collection_template', function () {
            PolkurierOrderJs.SetTemplatePack(PolkurierOrderJs.filterInt(jQuery(this).val()));
            jQuery(this).prop('selectedIndex', 0);
        });

        jQuery('.show_courier_point_map').on('click', function () {
            PolkurierCollectionPoint.ShowCourierPointMap(jQuery(this).data('target'));
        });

        jQuery('.polkurier_pickup_type').change(function () {

            var servicecode = PolkurierOrderJs.getServiceCode();
            if (servicecode === 'INPOST_PACZKOMAT' || servicecode === 'INPOST_PACZKOMAT_ECONOMY' || servicecode === 'INPOST_INTERNATIONAL') {
                if (jQuery(this).val() === 'SELF') {
                    jQuery('#polkurier_sender_station').prop('disabled', false);
                } else {
                    jQuery('#polkurier_sender_station').prop('disabled', true);
                }
            }
        });

        jQuery('#polkurier_date_pickup').change(function () {
            PolkurierOrderJs.pickup_time();
        });

        let time_out_calculate;
        jQuery(document).on('change paste keyup', '.pack-param', function (ekey) {
            clearTimeout(time_out_calculate);
            const e = ekey.keyCode;
            if (!(37 <= e && e <= 40 || 35 <= e && e <= 36 || 18 === e || 16 === e || 17 === e || 13 === e || undefined === e)) {
                if (jQuery(this).val() === "" || jQuery(this).val() === 0) {
                    clearTimeout(time_out_calculate);
                    return false;
                }
            }
            time_out_calculate = setTimeout(function () {
                PolkurierOrderJs.Calculate();
            }, 1200);
        });

        jQuery(document).ready(function () {
            PolkurierOrderJs.addRowPack();
            PolkurierOrderJs.pickup_time();
            {/literal}
            {if $POLKURIER_TEMPLATE_PARCEL_ID }
            PolkurierOrderJs.SetTemplatePack(PolkurierOrderJs.filterInt({$POLKURIER_TEMPLATE_PARCEL_ID}));
            PolkurierOrderJs.Calculate();
            {/if}
            {literal}

            jQuery('.polkurier_select2').select2({
                language: "pl",
                width: 'resolve',
                theme: "classic"
            });

            {/literal}
            {if $shipmentmodel->getServiceCode() }
            PolkurierOrderJs.ChangeServiceCode("{$shipmentmodel->getServiceCode()}");
            {/if}
            {literal}
        });
    </script>
{/literal}
    {include file='../admin/polkurier_download_file.tpl'}
{/if}
