<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\PickupCourier;

class PickupCourierApi extends ApiClient
{
    /**
     * @var string
     */
    private $pickup_date;
    /**
     * @var string
     */
    private $ship_form;
    /**
     * @var string
     */
    private $courier;
    /**
     * @var string
     */
    private $parcel;

    /**
     * @return array|mixed
     * @throws Exception
     */
    public function getPickup()
    {
        try {

            $pickup_courier_method = new PickupCourier();
            $pickup_courier_method->setPickupdate($this->pickup_date);
            $pickup_courier_method->setShipfrom($this->ship_form);
            $pickup_courier_method->setCourier($this->courier);
            $pickup_courier_method->setParcel($this->parcel);
            $this->webApi()->requestMethod($pickup_courier_method);
            return $pickup_courier_method->getData();

        } catch (ErrorException $ex) {
            throw new Exception($ex->getMessage());
        }
    }

    /**
     * @param string $pickup_date
     * @return $this
     */
    public function setPickupDate($pickup_date)
    {
        $this->pickup_date = $pickup_date;
        return $this;
    }

    /**
     * @param string $ship_form
     * @return $this
     */
    public function setShipForm($ship_form)
    {
        $this->ship_form = $ship_form;
        return $this;
    }

    /**
     * @param string $courier
     * @return $this
     */
    public function setCourier($courier)
    {
        $this->courier = $courier;
        return $this;
    }

    /**
     * @param string $parcel
     * @return $this
     */
    public function setParcel($parcel)
    {
        $this->parcel = $parcel;
        return $this;
    }
}