<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\GetProtocol;

class ProtocolOrderApi extends ApiClient
{
    /**
     * @var array
     */
    private $order_number = [];

    /**
     * @return mixed|void
     */
    public function getProtocol()
    {
        if (!empty($this->order_number)) {

            try {
                $method = new GetProtocol();
                foreach ($this->order_number as $item) {
                    $method->addOrderNumber($item);
                }
                $this->webApi()->requestMethod($method);
                return $method->getData()->getContent();
            } catch (Exception $ex) {
            } catch (ErrorException $ex) {
            }
        }
    }

    /**
     * @param string $order_number
     */
    public function setOrderNumber($order_number)
    {
        $this->order_number[] = $order_number;
    }
}