<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Bank;

class Bank
{
    /**
     * @param array $data
     * @return bool|int|string
     */
    public static function SaveBankAccountData($data = [])
    {
        $bank_id = null;
        if (isset($data['bank_id'])) {
            if (is_numeric($data['bank_id'])) {
                $bank_id = $data['bank_id'];
            }
            unset($data['bank_id']);
        }
        
        $bank_field = [
            'name' => '',
            'iban' => '',
        ];
        
        foreach ($bank_field as $key => &$item) {
            if (isset($data[$key])) {
                $item = $data[$key];
            }
        }
        
        $empty = true;
        foreach ($bank_field as $key => &$item) {
            if (!empty($item)) {
                $empty = false;
            }
        }
        
        if (!$empty) {
            if (is_numeric($bank_id)) {
                return BankModel::UpdateBankAccount($bank_field, $bank_id);
            }
            return BankModel::InsertBankAccount($bank_field);
        }
    }
}