<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */
namespace Polkurier\Bank;

class BankModel extends SqlBank
{
    /**
     * @param array $data
     * @return array
     */
    public static function PrepareArrayBankAccount($data = [])
    {
        return [
            'name' => pSQL($data['name']),
            'iban' => pSQL(preg_replace('/\D/', '', $data['iban'])),
        ];
    }
    
    /**
     * @param array $data
     * @return int|string
     */
    public static function InsertBankAccount($data = [])
    {
        return parent::insertSql(
            self::PrepareArrayBankAccount($data)
        );
    }
    
    /**
     * @param array $data
     * @param int $id
     * @return bool
     */
    public static function UpdateBankAccount($data, $id)
    {
        if(!is_numeric($id)){
            return;
        }
        return parent::updateSql(
            self::PrepareArrayBankAccount($data), $id
        );
    }
}