<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 * @since      1.0.1
 */
namespace PolkurierApi\CollectionPoint;

use Polkurier\CollectionPoint\CollectionPointModel;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\DeliveryPoint\Apaczka\ApaczkaDeliveryPoint;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\Furgonetka\FurgonetkaPaczkomaty;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\InpostShipping\InpostShipping;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\PrestaModPl\PmInpostPaczkomaty;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\Sensbit\SensbitInpost;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\Sensbit\SensbitPaczkomaty;
use Module;
use Order;

final class DeliveryPointAddressModule
{
    /**
     * @var int
     */
    private $id_order;

    public function __construct($id_order)
    {
        $this->id_order = (int)$id_order;
    }

    public function getDeliveryPoint()
    {
        if (Module::isInstalled('sensbitpaczkomatymap') === true) {
            $collection_point = SensbitPaczkomaty::getIdMachines($this->id_order);
            if (!is_null($collection_point)) {
                return $collection_point;
            }
        }

        if (Module::isInstalled('sensbitinpost') === true) {
            $collection_point = SensbitInpost::getIdMachines($this->id_order);
            if (!is_null($collection_point)) {
                return $collection_point;
            }
        }

        $order = new Order($this->id_order);
        if (Module::isInstalled('pminpostpaczkomaty') === true) {
            $collection_point = PmInpostPaczkomaty::getMachinesId($order->id_cart);
            if (!is_null($collection_point)) {
                return $collection_point;
            }
        }

        if (Module::isInstalled('furgonetka') === true) {
            $collection_point = FurgonetkaPaczkomaty::getIdMachines($order->id_cart);
            if (!is_null($collection_point)) {
                return $collection_point;
            }
        }

        if (Module::isInstalled('inpostshipping') === true) {
            $collection_point = InpostShipping::getMachinesId($order->id_cart);
            if (!is_null($collection_point)) {
                return $collection_point['point'];
            }
        }

        if (Module::isInstalled('apaczka') === true) {
            $collection_point = ApaczkaDeliveryPoint::getDeliveryPoint($order->id_cart);
            if (!is_null($collection_point)) {
                $this->receiver->setStation($collection_point);
                return;
            }
        }

        $collection_point = CollectionPointModel::getCollectionPointByIdCart($order->id_cart);
        if (!empty($collection_point)) {
            return $collection_point['collection_point'];
        }
    }
}