<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 
 */

namespace Polkurier\Model;

use Polkurier\Bank\BankListModel;
use Polkurier\CodReturnTime;
use Polkurier\CodType;
use Polkurier\Parcel\ParcelListModel;
use Polkurier\Sender\SenderListModel;

abstract class Model
{
    /**
     * @var array
     */
    protected static $config_value = [];

    /**
     * Lista adresów nadawczych
     * @var SenderListModel
     */
    public static $sender_list;

    /**
     * Tablica dostępnych przewoźników
     * @var array
     */
    public static $couriers = [];

    /**
     * Domyślny typ pickup
     * @var string
     */
    public static $default_pickup_type = 'COURIER';

    /**
     * Tablica radzajów pickup
     * @var array
     */
    public static $pickup_courier_type_option = [];

    /**
     * Typ pickup
     * @var array
     */
    public static $pickup_courier_type = ['COURIER' => true, 'SELF' => false];

    /**
     * domyślny rodzaj przesyłki
     * @var string
     */
    public static $default_shipment_type = 'box';

    /**
     * lista szablonów paczek - options
     * Pobieranie przez getListOption()
     * @var ParcelListModel
     */
    public $parcel_list_options;

    /**
     * tablica szablonów paczek
     * Pobieranie przez getList()
     * @var ParcelListModel
     */
    public static $parcel_template_list;

    /**
     * Rodzaje przesyłek
     * @var array
     */
    public static $shipment_type = [];

    /**
     * Lista kont bankowych
     * Pobieranie przez getList()
     * Pobieranie przez getListOption()
     * @var BankListModel
     */
    public static $bank_list;


    /**
     * @var \Polkurier\Model\CountryModel
     */
    public static $countries;

    /**
     * @var array
     */
    public static $codtype = CodType::NAME;

    /**
     * @var array
     */
    public static $cod_return_time = CodReturnTime::NAME;

    /**
     * @var string
     */
    public static $cod_return_time_default = CodReturnTime::DEFAULT_TYPE;
}
