<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment\NewShipment;


use Polkurier\ConfigurationKey;
use Polkurier\Model\PolkurierConfig;
use Polkurier\Model\Shipment\Sender;

final class SenderAddressModel
{

    public function __construct()
    {
    }
    
    /**
     * Adres nadawcy
     * @return \Polkurier\Model\Shipment\Sender
     */
    public function getSenderAddress()
    {
        $address = [];
        $sender_list = PolkurierConfig::$sender_list->getList();
        if (is_array($sender_list) && count($sender_list) > 0) {
            
            if (count($sender_list) === 1) {
                $address = current($sender_list);
            } else {
                if (isset($sender_list[PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_DEFAULT_SENDER_ID)])) {
                    $address = $sender_list[PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_DEFAULT_SENDER_ID)];
                } else {
                    $address = current($sender_list);
                }
            }
        }
        return $this->updateSenderAddress($address);
    }
    
    
    /**
     * @param array $address
     * @return \Polkurier\Model\Shipment\Sender
     */
    private function updateSenderAddress($address = [])
    {
        $sender = new Sender();
        if (!empty($address)) {
            $sender->setCompany($address['company']);
            $sender->setStreet($address['street']);
            $sender->setHouseNo($address['house_no']);
            $sender->setFlatNo($address['flat_no']);
            $sender->setPostcode($address['postcode']);
            $sender->setCity($address['city']);
            $sender->setFirstname($address['first_name']);
            $sender->setLastname($address['last_name']);
            $sender->setPhone($address['phone']);
            $sender->setEmail($address['email']);
            $sender->setContactName($address['contact_name']);
        }
        return $sender;
    }
}