<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

final class Receiver extends OrderAdres
{
    /**
     * @var string|null
     */
    private $address_1;
    
    /**
     * @var string|null
     */
    private $address_2;
    
    /**
     * @var string|null
     */
    private $country_name;
    
    /**
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->address_1;
    }
    
    /**
     * @param string|null $address_1
     * @return $this
     */
    public function setAddress1($address_1)
    {
        $this->address_1 = (string)$address_1;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address_2;
    }
    
    /**
     * @param string|null $address_2
     * @return $this
     */
    public function setAddress2($address_2)
    {
        $this->address_2 = (string)$address_2;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->country_name;
    }
    
    /**
     * @param string|null $country_name
     * @return $this
     */
    public function setCountryName($country_name)
    {
        $this->country_name = (string)$country_name;
        return $this;
    }
}