<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

final class Sender extends OrderAdres
{
    
    /**
     * @var string|null
     */
    private $contact_name;
    
    /**
     * @return string|null
     */
    public function getContactName()
    {
        return $this->contact_name;
    }
    
    /**
     * @param string|null $contact_name
     * @return $this
     */
    public function setContactName($contact_name)
    {
        $this->contact_name = (string)$contact_name;
        return $this;
    }
}