<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl

 */

namespace Polkurier\Model\Shipment;

use Polkurier\ParcelOrder\ModelParcelOrder;

final class ShipmentModel
{
    /**
     * @var int
     */
    private $presta_id_order;
    /**
     * @var string
     */
    private $polkurier_id_order;
    /**
     * Numer listu przewozowego
     * @var string
     */
    private $order_label;
    /**
     * Adres odbiorcy
     * @var Receiver
     */
    private $receiver;
    /**
     * Adres nadawcy
     * @var Sender
     */
    private $sender;
    /**
     * Typ wysyłki
     * @var string
     */
    private $shipment_type;
    /**
     * @var array ShipmentModelPack
     */
    private $shipment_Pack = [];
    /**
     * Ubezpieczenie
     * @var float
     */
    private $insurance_value = 0.00;
    /**
     * @var CodShipment
     */
    private $cod_shipment;
    /**
     * Zawartość przesyłki
     * @var string
     */
    private $order_content = '';
    /**
     * Przwoźnik
     * @var string
     */
    private $service_code;
    /**
     * koszt przesyłki netto
     * @var float
     */
    private $order_netto = 0.00;
    /**
     * Koszt przesyłki brutto
     * @var float
     */
    private $order_brutto = 0.00;
    /**
     * Status zamówienia
     * @var string
     */
    private $order_status;
    /**
     * @var ShipmentPickup
     */
    private $shipment_pickup;
    /**
     * @var string
     */
    private $url_tracktrace;
    /**
     * @var ShipmentAdditionalServices
     */
    private $shipmentadditionalservices;

    public function __construct()
    {
        $this->receiver = new Receiver();
        $this->sender = new Sender();
        $this->cod_shipment = new CodShipment();
        $this->shipment_pickup = new ShipmentPickup();
        $this->shipmentadditionalservices = new ShipmentAdditionalServices();
    }

    /**
     * @return string|null
     */
    public function getUrlTracktrace()
    {
        return $this->url_tracktrace;
    }

    /**
     * @param string|null $url_tracktrace
     * @return $this
     */
    public function setUrlTracktrace($url_tracktrace)
    {
        $this->url_tracktrace = (string)$url_tracktrace;
        return $this;
    }

    /**
     * @return ShipmentPickup
     */
    public function getShipmentPickup()
    {
        return $this->shipment_pickup;
    }


    public function setShipmentPickup(ShipmentPickup $shipment_pickup)
    {
        $this->shipment_pickup = $shipment_pickup;
        return $this;
    }


    public function getCodShipment()
    {
        return $this->cod_shipment;
    }

    public function setCodShipment(CodShipment $cod_shipment)
    {
        $this->cod_shipment = $cod_shipment;
        return $this;
    }

    public function getOrderNetto()
    {
        return $this->order_netto;
    }

    /**
     * @param float $order_netto
     * @return $this
     */
    public function setOrderNetto($order_netto = 0.00)
    {
        $this->order_netto = (float)$order_netto;
        return $this;
    }

    /**
     * @return float
     */
    public function getOrderBrutto()
    {
        return $this->order_brutto;
    }

    /**
     * @param float $order_brutto
     * @return $this
     */
    public function setOrderBrutto($order_brutto = 0.00)
    {
        $this->order_brutto = (float)$order_brutto;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->order_status;
    }

    /**
     * @param string $order_status
     * @return $this
     */
    public function setOrderStatus($order_status)
    {
        $this->order_status = (string)$order_status;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getOrderLabel()
    {
        return $this->order_label;
    }

    public function setOrderLabel($order_label)
    {
        $this->order_label = (string)$order_label;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->service_code;
    }

    /**
     * @param string|null $service_code
     * @return $this
     */
    public function setServiceCode($service_code)
    {
        $this->service_code = (string)$service_code;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getOrderContent()
    {
        return $this->order_content;
    }

    /**
     * @param string|null $order_content
     * @return $this
     */
    public function setOrderContent($order_content)
    {
        $this->order_content = (string)$order_content;
        return $this;
    }

    /**
     * @return int
     */
    public function getPrestaIdOrder()
    {
        return $this->presta_id_order;
    }

    /**
     * @param int $presta_id_order
     * @return $this
     */
    public function setPrestaIdOrder($presta_id_order)
    {
        $this->presta_id_order = (int)$presta_id_order;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPolkurierIdOrder()
    {
        return $this->polkurier_id_order;
    }

    /**
     * @param string|null $polkurier_id_order
     * @return $this
     */
    public function setPolkurierIdOrder($polkurier_id_order)
    {
        $this->polkurier_id_order = (string)$polkurier_id_order;
        return $this;
    }

    /**
     * @return Receiver
     */
    public function getReceiver()
    {
        return $this->receiver;
    }

    /**
     * @param Receiver $receiver
     * @return $this
     */
    public function setReceiver(Receiver $receiver)
    {
        $this->receiver = $receiver;
        return $this;
    }

    /**
     * @return Sender
     */
    public function getSender()
    {
        return $this->sender;
    }

    /**
     * @param Sender $sender
     * @return $this
     */
    public function setSender(Sender $sender)
    {
        $this->sender = $sender;
        return $this;
    }

    /**
     * @return string
     */
    public function getShipmentType()
    {
        return $this->shipment_type;
    }

    /**
     * @param string $shipment_type
     * @return $this
     */
    public function setShipmentType($shipment_type)
    {
        $this->shipment_type = (string)$shipment_type;
        return $this;
    }

    /**
     * @return ShipmenPack[]
     */
    public function getShipmentPack()
    {
        return $this->shipment_Pack;
    }

    /**
     * @param ShipmenPack $shipment_Pack
     * @return $this
     */
    public function setShipmentPack(ShipmenPack $shipment_Pack)
    {
        $this->shipment_Pack[] = $shipment_Pack;
        return $this;
    }

    /**
     * @return float
     */
    public function SumWeightShipmentPack()
    {

        $packarray = [];
        foreach ($this->getShipmentPack() as $item) {
            $packarray[] = $item->getWeight() * $item->getAmount();
        }
        return (float)array_sum($packarray);
    }

    /**
     * @return float
     */
    public function getInsuranceValue()
    {
        return $this->insurance_value;
    }

    /**
     * @param float $insurance_value
     * @return $this
     */
    public function setInsuranceValue($insurance_value = 0.00)
    {
        $this->insurance_value = (float)$insurance_value;
        return $this;
    }

    /**
     * @return ShipmentAdditionalServices
     */
    public function getShipmentadditionalservices()
    {
        return $this->shipmentadditionalservices;
    }

    /**
     * @param string $shipmentadditionalservices
     */
    public function setShipmentadditionalservices($shipmentadditionalservices)
    {
        $this->shipmentadditionalservices->setServices($shipmentadditionalservices);
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
}
