<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 
 */

namespace Polkurier\Model\Shipment;

final class ShipmentPickup
{
    /**
     * @var bool
     */
    private $nocourier = false;
    /**
     * @var string
     */
    private $date;
    /**
     * @var string
     */
    private $timefrom;
    /**
     * @var string
     */
    private $timeto;
    
    /**
     * @return bool
     */
    public function isNocourier()
    {
        return $this->nocourier;
    }
    
    /**
     * @param bool $nocourier
     * @return $this
     */
    public function setNocourier($nocourier = false)
    {
        $this->nocourier = (bool)$nocourier;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    
    /**
     * @param string $date
     * @return $this
     */
    public function setDate($date)
    {
        $this->date = (string)$date;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getTimefrom()
    {
        return $this->timefrom;
    }
    
    /**
     * @param string $timefrom
     * @return $this
     */
    public function setTimefrom($timefrom)
    {
        $this->timefrom = (string)$timefrom;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getTimeto()
    {
        return $this->timeto;
    }
    
    /**
     * @param string $timeto
     * @return $this
     */
    public function setTimeto($timeto)
    {
        $this->timeto = (string)$timeto;
        return $this;
    }
}