<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 
 */

namespace Polkurier\Model;

use DateTime;

abstract class SqlAbstract
{
    /**
     * @return string
     */
    protected static function Orders()
    {
        return _DB_PREFIX_ . 'pk_orders';
    }

    /**
     * @return string
     */
    protected static function Sender()
    {
        return _DB_PREFIX_ . 'pk_sender';
    }

    /**
     * @return string
     */
    protected static function OrderSender()
    {
        return _DB_PREFIX_ . 'pk_order_sender';
    }

    /**
     * @return string
     */
    protected static function Receiver()
    {
        return _DB_PREFIX_ . 'pk_order_receiver';
    }

    /**
     * @return string
     */
    protected static function BankAccount()
    {
        return _DB_PREFIX_ . 'pk_bank';
    }

    /**
     * @return string
     */
    protected static function Parcel()
    {
        return _DB_PREFIX_ . 'pk_parcel';
    }

    /**
     * @return string
     */
    protected static function OrderParcel()
    {
        return _DB_PREFIX_ . 'pk_order_parcel';
    }

    /**
     * @return string
     */
    protected static function PostOffices()
    {
        return _DB_PREFIX_ . 'pk_postoffices';
    }

    /**
     * @return string
     */
    protected static function PointsInpost()
    {
        return _DB_PREFIX_ . 'pk_points_inpost';
    }

    /**
     * @return string
     */
    protected static function CollectionPoint()
    {
        return _DB_PREFIX_ . 'pk_collection_point';
    }


    /**
     * @return string
     * @throws \Exception
     */
    protected static function currentTime()
    {
        return (new DateTime("NOW"))->format('Y-m-d H:i:s');
    }
}