<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Polkurier\ApiMetod\OrderValuationApi;
use Polkurier\Model\PolkurierConfig;
use Polkurier\Model\Shipment\FormShipment\FormShipmentModel;
use Polkurier\Model\Shipment\ShipmentModel;
use Exception;

final class OrderValuation
{
    /**
     * @var array
     */
    private $dataform = [];

    /**
     * @return array
     * @throws Exception
     */
    public function Valuation()
    {
        $shipmentmodel = new ShipmentModel();
        (new FormShipmentModel($shipmentmodel,$this->dataform))->SetModel();
        $resp = (new OrderValuationApi())->getValuation($shipmentmodel);
        if (empty($resp)) {
            throw new Exception('Wykonanie wyceny jest nie możliwe.');
        }
        return $resp;
    }
    
    /**
     * @param array $dataform
     * @return $this
     */
    public function setDataform($dataform = [])
    {
        $this->dataform = $dataform;
        return $this;
    }
}