<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Parcel;

use Polkurier\Model\SqlAbstract;
use Db;
use PrestaShopDatabaseException;

class ParcelSql extends SqlAbstract
{
    /**
     * @param array $data
     * @return int|string
     */
    public static function insertSql($data = [])
    {
        Db::getInstance()->insert(parent::Parcel(), $data, false, false, Db::INSERT, false);
        return Db::getInstance()->Insert_ID();
    }
    
    /**
     * @param array $data
     * @param int $id
     * @return bool
     */
    public static function updateSql($data, $id)
    {
        return Db::getInstance()->update(parent::Parcel(), $data, 'parcel_id = ' . (int)$id, 0, false, false, false);
    }
    
    
    /**
     * @param int $id
     * @return array|bool|object|null
     */
    public static function getParcelById($id)
    {
        try {
            return Db::getInstance()->getRow('SELECT * FROM ' . parent::Parcel() . ' WHERE parcel_id = ' . (int)$id .';');
        } catch (PrestaShopDatabaseException $e) {
            return [];
        }
    }
    
    
    /**
     * @param $id
     * @return bool
     * @throws \Exception
     */
    public static function deleteParcel($id)
    {
        if (!is_numeric($id)) {
            throw new Exception('Parcel Id is empty ' . $id);
        }
        return Db::getInstance()->delete(parent::Parcel(), 'parcel_id='.(int)$id, 1, false, false);
    }
    
    /**
     * @param array $attributes
     * @return array|false|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getParcelList($attributes = [])
    {
        $columns = '*';
        if (!empty($attributes)) {
            $columns = implode(',', $attributes);
        }
        $sql = "SELECT $columns FROM " . self::Parcel();
        try {
            return Db::getInstance()->executeS($sql);
        } catch (PrestaShopDatabaseException $e) {
            return [];
        }
    }
    
    /**
     * @return array|false|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getParcelTemplateList()
    {
        $result = [];
        try {
            $retrun = Db::getInstance()->executeS("SELECT * FROM " . self::Parcel());
            if(is_array($retrun)){
                foreach ($retrun as $item) {
                    $result[$item['parcel_id']] = $item;
                }
            }
            return $result;
        } catch (PrestaShopDatabaseException $e) {
            return [];
        }
    }
}