<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 
 */

namespace Polkurier;

use Polkurier\ApiMetod\AvailableCarriersApi;
use Polkurier\Model\PolkurierConfig;
use Exception;

/**
 * Aktualizuje dane z API
 */
class UpdateConfigPolkurierApi
{
    public function __construct()
    {
        $this->getCouriers();
    }

    /**
     * Dostępni przewoźnicy
     */
    private function getCouriers()
    {
        $couriers = [];
        try{
            $resp = (new AvailableCarriersApi())->getCarriers();
            if (is_array($resp)) {
                foreach ($resp as $carrier) {
                    $couriers[$carrier->getServicecode()] = [
                        'id' => $carrier->getServicecode(),
                        'name' => $carrier->getName()
                    ];
                }
            }
        }catch (Exception $ex){
        }

        PolkurierConfig::$couriers = $couriers;
    }
}