<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */


class ConfigBankAccountView extends ViewAbstract
{
    /**
     * @var string
     */
    protected static $template = '/views/templates/admin/bank_account_form.tpl';
    
    /**
     * @return string
     */
    public static function getTemplate()
    {
        return self::$template;
    }
    
    /**
     * @return array
     */
    public static function getFormConfig()
    {
        return [
            'form' => [
                'legend' => [
                    'title' => 'Numery kont bankowych',
                ],
                'input' => [
                    [
                        'type' => 'hidden',
                        'name' => 'bank_id'
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Nazwa na liście',
                        'name' => 'name',
                        'maxlength' => 50,
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'label' => 'Numer IBAN',
                        'name' => 'iban',
                        'maxlength' => 50,
                    ],
                ],
                'submit' => [
                    'title' => 'Zapisz',
                    'class' => 'button pull-right',
                ]
            ]
        ];
    }
}
