var collection = POLKURIER_COLLECTION_POINT_API_CODE || [];

var PolkurierCollectionPoint = {

    InsertCollectionPoint: function (options) {

        options = options || {};
        var props = {
            'id_cart': ID_CART,
            'collection_point': options.id,
            'city': options.city,
            'provider': options.provider,
            'street': options.street,
            'zip': options.zip
        };

        jQuery.ajax({
            type: 'POST',
            url: POLKURIER_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
            async: true,
            cache: false,
            data: {
                'id_cart': ID_CART,
                'collection_point': props.collection_point,
                'providers': props.provider,
                'adres': props.city + ' ' + props.zip + ' ' + props.street,
            },
            success: function () {
                PolkurierCollectionPoint.HideWarning(props.provider);
            },
        });
        let string = props.collection_point + '|' + props.city + ' ' + props.zip + ' ' + props.street;
        jQuery('#input_chosen_point_' + props.provider).val(string);
        jQuery('#chosen_collection_point_' + props.provider).html(string);
    },

    UpdateCollectionPoint: function (provider) {

        let str = jQuery('#input_chosen_point_' + provider).val();
        if (str) {
            let res = str.split("|", 2);
            if (res.length > 1) {
                let adres = res[1];
                let collection_point = res[0];
                jQuery.ajax({
                    type: 'POST',
                    url: POLKURIER_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
                    async: true,
                    cache: false,
                    data: {
                        'id_cart': ID_CART,
                        'collection_point': collection_point,
                        'providers': provider,
                        'adres': adres,
                    },
                    success: function (result) {
                    },
                });
            }
        } else {
            this.clearCollectionPoint();
        }
    },

    clearCollectionPoint: function () {
        jQuery.ajax({
            type: 'POST',
            url: POLKURIER_DELETE_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
            async: true,
            cache: false,
            data: {
                'id_cart': ID_CART
            },
            success: function (result) {
            },
        });
    },

    ShowWarning: function (provider) {
        jQuery('#collection-point-warning-' + provider).removeClass('hidden');
    },

    HideWarning: function (provider) {
        jQuery('#collection-point-warning-' + provider).addClass('hidden');
    },

    isEmptyChosenPoint: function (provider) {
        return jQuery('#input_chosen_point_' + provider).val().length === 0
    },

    getDO: function () {
        if (jQuery('.delivery_option').length) {
            return '.delivery_option';
        }
        return '.delivery_options';
    },

    ShowSelectWidget: function (provider) {
        this.HideAllSelectWidget();
        jQuery('#select-widget-' + provider).removeClass('hidden');
    },

    HideAllSelectWidget: function () {
        jQuery('.select-widget-polkurier').addClass('hidden');
    },

    RanderInputPolkurier: function () {
        jQuery(this.getDO() + ' input[type="radio"]').each(function () {
            let carrierid = parseInt(jQuery(this).val());
            let provider = collection[carrierid] || false;
            if (provider) {

                var map_options = {
                    'providers': provider,
                    'searchQuery': POLKURIER_SEARCH_QUERY,
                    'input_chosen': 'input_chosen_point_' + provider,
                    'functions': ['collect'],
                };

                var chosen_collection_point = '';
                if (POLKURIER_CHOSEN_COLLECTION_POINT[provider]) {
                    chosen_collection_point = POLKURIER_CHOSEN_COLLECTION_POINT[provider];
                }

                let button = '<div class="polkurier-parcellocker-button col-sm-12">\n' +
                    '    <p class="chosen-collection">Wybrany punkt odbioru: <span class="chosen-collection-point" id="chosen_collection_point_' + provider + '">' + chosen_collection_point + '</span></p>\n' +
                    '    <div class="chosen-button"><button class="btn btn-default btn-primary" onclick=\'PolkurierPointsMap.showPointsMap(' + JSON.stringify(map_options) + ');return false;\'>Wybierz punkt odbioru</button></div>\n' +
                    '    <input type="hidden" value="' + chosen_collection_point + '" id="input_chosen_point_' + provider + '">\n' +
                    '    <p class="polkurier-parcellocker-warning hidden" id="collection-point-warning-' + provider + '">Proszę wybrać punkt odbioru</p>\n' +
                    '</div>';

                let select_widget = '<div id="select-widget-' + provider + '" class="select-widget-polkurier hidden"><div class="col-100">' + button + '</div></div></div>';

                jQuery(this).closest('table').parent().append(select_widget);
            }
        });
    }
};


jQuery(document).ready(function () {

    PolkurierCollectionPoint.RanderInputPolkurier();

    jQuery('button[name="processCarrier"]').click(function (event) {
        let curent_checked = parseInt(jQuery(PolkurierCollectionPoint.getDO() + ' input[type="radio"]:checked').val());
        let provider = collection[curent_checked] || false;
        if (provider) {
            if (PolkurierCollectionPoint.isEmptyChosenPoint(provider)) {
                PolkurierCollectionPoint.ShowWarning(provider);
                event.preventDefault();
            }
        }
    });

    jQuery(PolkurierCollectionPoint.getDO() + ' input[type="radio"]').on('change', function () {
        let provider = collection[parseInt(jQuery(this).val())] || false;
        if (provider) {
            PolkurierCollectionPoint.UpdateCollectionPoint(provider);
            PolkurierCollectionPoint.ShowSelectWidget(provider);
        } else {
            PolkurierCollectionPoint.clearCollectionPoint();
            PolkurierCollectionPoint.HideAllSelectWidget();
        }
    });

    if (jQuery(PolkurierCollectionPoint.getDO() + ' input[type="radio"]:checked').val() !== 'undefined') {
        let curent_checked = parseInt(jQuery(PolkurierCollectionPoint.getDO() + ' input[type="radio"]:checked').val());
        let provider = collection[curent_checked] || false;
        if (provider) {
            PolkurierCollectionPoint.ShowSelectWidget(provider);
        }
    }
});
