var collection = POLKURIER_COLLECTION_POINT_API_CODE || [];

var PolkurierCollectionPoint = {

    InsertCollectionPoint: function (options) {

        options = options || {};
        var props = {
            'id_cart': ID_CART,
            'collection_point': options.id,
            'city': options.city,
            'provider': options.provider,
            'street': options.street,
            'zip': options.zip
        };

        jQuery.ajax({
            type: 'POST',
            url: POLKURIER_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
            async: true,
            cache: false,
            data: {
                'id_cart': ID_CART,
                'collection_point': props.collection_point,
                'providers': props.provider,
                'adres': props.city + ' ' + props.zip + ' ' + props.street,
            },
            success: function () {
                PolkurierCollectionPoint.HideWarning(props.provider);
            },
        });
        let string = props.collection_point + '|' + props.city + ' ' + props.zip + ' ' + props.street;
        jQuery('#input_chosen_point_' + props.provider).val(string);
        jQuery('#chosen_collection_point_' + props.provider).html(string);
    },

    UpdateCollectionPoint: function (provider) {

        let str = jQuery('#input_chosen_point_' + provider).val();
        if (str) {
            let res = str.split("|", 2);
            if (res.length > 1) {
                let adres = res[1];
                let collection_point = res[0];
                jQuery.ajax({
                    type: 'POST',
                    url: POLKURIER_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
                    async: true,
                    cache: false,
                    data: {
                        'id_cart': ID_CART,
                        'collection_point': collection_point,
                        'providers': provider,
                        'adres': adres,
                    },
                    success: function (result) {
                    },
                });
            }
        } else {
            this.clearCollectionPoint();
        }
    },

    clearCollectionPoint: function (){
        jQuery.ajax({
            type: 'POST',
            url: POLKURIER_DELETE_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
            async: true,
            cache: false,
            data: {
                'id_cart': ID_CART
            },
            success: function (result) {
            },
        });
    },

    ShowWarning: function (provider) {
        jQuery('#collection-point-warning-' + provider).show();
    },

    HideWarning: function (provider) {
        jQuery('#collection-point-warning-' + provider).hide();
    },

    isEmptyChosenPoint: function (provider) {
        return jQuery('#input_chosen_point_' + provider).val().length === 0
    },

    ShowSelectWidget: function (provider) {
        this.HideAllSelectWidget();
        var selectwidget = jQuery('#chosen_collection_point_' + provider).parent().parent().parent();
        selectwidget.show();
        selectwidget.css("display", "");
    },

    HideAllSelectWidget: function () {
        jQuery(".polkurier-parcellocker-button").each(function () {
            var parent = jQuery(this).parent().hide();
        });
    }
};


jQuery(document).ready(function () {

    var form = jQuery('button[name="submitCompleteMyOrder"]').closest('form');
    jQuery(form).submit(function(event){
        let curent_checked = parseInt(jQuery('.delivery-options input[type="radio"]:checked').val());
        let provider = collection[curent_checked] || false;
        if (provider) {
            if (PolkurierCollectionPoint.isEmptyChosenPoint(provider)) {
                PolkurierCollectionPoint.ShowWarning(provider);
                jQuery("html, body").animate({scrollTop: 0}, "slow");
                event.preventDefault();
            }
        }
    });

    jQuery('.delivery-options input[type="radio"]').on('change', function () {
        var extendsid = parseInt(jQuery(this).val());
        let provider = collection[extendsid] || false;
        if (provider) {
            PolkurierCollectionPoint.UpdateCollectionPoint(provider);
            PolkurierCollectionPoint.ShowSelectWidget(provider);
        } else {
            PolkurierCollectionPoint.clearCollectionPoint();
            PolkurierCollectionPoint.HideAllSelectWidget();
        }
    });
});