<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use Polkurier\Model\Shipment\ShipmentAdditionalServices;
use Polkurier\Model\Shipment\ShipmentModel;
use PolkurierWebServiceApi\Entities\CourierWithLabelCourierService;
use PolkurierWebServiceApi\Entities\Pack;
use PolkurierWebServiceApi\Entities\SmsNotificationRecipientCourierService;
use PolkurierWebServiceApi\Entities\WeekCollectionCourierService;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\CreateOrder;
use PolkurierWebServiceApi\Methods\OrderValuation;

class OrderValuationApi extends ApiClient
{

    /**
     * @param ShipmentModel $shipment
     * @return array
     * @throws Exception
     */
    public function getValuation(ShipmentModel $shipment)
    {
        try {

            $ordervaluation = new OrderValuation();
            /** @var Pack $item */
            foreach ((new ApiUtils())->setPack($shipment->getShipmentPack()) as $item) {
                $ordervaluation->addPack($item);
            }
            $ordervaluation->setShipmentType($shipment->getShipmentType());

            $ordervaluation->setCOD($shipment->getCodShipment()->getValue());

            $ordervaluation->setCodtype($shipment->getCodShipment()->getTime());

            $ordervaluation->setReturnCod($shipment->getCodShipment()->getType());

            $ordervaluation->setInsurance($shipment->getInsuranceValue());

            $ordervaluation->setPostcodeSender($shipment->getSender()->getPostcode());

            $ordervaluation->setPostcodeRecipient($shipment->getReceiver()->getPostcode());

            if ($shipment->getReceiver()->getCountry()) {
                $country_iso = (new ApiUtils())->getCountryIso($shipment->getReceiver()->getCountry());
                if (!empty($country_iso)) {
                    $ordervaluation->setRecipientCountry($country_iso);
                }
            }

            $this->setShipmentAdditionalServices($ordervaluation, $shipment->getShipmentadditionalservices());

            $this->webApi()->requestMethod($ordervaluation);

            return $ordervaluation->toArray();

        } catch (ErrorException $ex) {
            throw new Exception($ex->getMessage());
        }
    }

    /**
     * @param OrderValuation $ordervaluation
     * @param ShipmentAdditionalServices $services
     */
    private function setShipmentAdditionalServices(OrderValuation $ordervaluation, ShipmentAdditionalServices $services)
    {
        if ($services->isServices(ShipmentAdditionalServices::SMS_NOTIFICATION_RECIPIENT)) {
            $ordervaluation->addCourierService(new SmsNotificationRecipientCourierService(true));
        }

        if ($services->isServices(ShipmentAdditionalServices::COURIER_PRINTED_LABEL)) {
            $ordervaluation->addCourierService(new CourierWithLabelCourierService(true));
        }

        if ($services->isServices(ShipmentAdditionalServices::COURIER_WEEK_COLLECTION)) {
            $ordervaluation->addCourierService(new WeekCollectionCourierService(true));
        }
    }
}