<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Polkurier\Model\Shipment\Receiver;
use Polkurier\Model\Shipment\ShipmentAdditionalServices;
use Polkurier\Model\Shipment\ShipmentModel;
use Polkurier\Model\Shipment\ShipmentPickup;
use PolkurierWebServiceApi\Entities\CourierWithLabelCourierService;
use PolkurierWebServiceApi\Entities\Pack;
use PolkurierWebServiceApi\Entities\Pickup;
use PolkurierWebServiceApi\Entities\Recipient;
use PolkurierWebServiceApi\Entities\RodCourierService;
use PolkurierWebServiceApi\Entities\SmsNotificationRecipientCourierService;
use PolkurierWebServiceApi\Entities\WeekCollectionCourierService;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\CreateOrder;
use PolkurierWebServiceApi\Type\ShipmentType;
use Exception;

class PlaceOrderApi extends ApiClient
{
    /**
     * @param ShipmentModel $shipment
     * @return array|mixed
     * @throws Exception
     */
    public function getOrder(ShipmentModel $shipment)
    {
        try {

            $method = new CreateOrder();
            $method->setPlatform(4);
            $method->setCourier($shipment->getServiceCode());

            $method->setDescription($shipment->getOrderContent());
            $method->setShipmentType(ShipmentType::BOX);
            if (!empty($shipment->getShipmentType())) {
                $method->setShipmentType($shipment->getShipmentType());
            }

            /**
             * Wymiary paczek w przesyłce
             * @var Pack $item
             */
            foreach ((new ApiUtils())->setPack($shipment->getShipmentPack()) as $item) {
                $method->addPack($item);
            }

            /* Adres odbiorcy */
            $method->setRecipient(
                (new ApiUtils())->setRecipient($shipment->getReceiver())
            );

            /* Adres nadawcy */
            $method->setSender(
                (new ApiUtils())->setSender($shipment->getSender())
            );

            /* COD */
            if ($shipment->getCodShipment()->getValue() > 0) {
                $method->setCOD(
                    (new ApiUtils())->setCod($shipment->getCodShipment())
                );
            }

            /* Podjazd kuriera */
            $method->setPickup(
                (new ApiUtils())->setPickup($shipment->getShipmentPickup())
            );

            /* Ubezpieczenie */
            $method->setInsurance($shipment->getInsuranceValue());

            $this->setShipmentAdditionalServices($method, $shipment->getShipmentadditionalservices());

            $this->webApi()->requestMethod($method);

            return $method->getData();

        } catch (ErrorException $ex) {
            throw new Exception($ex->getMessage());
        }
    }


    private function setShipmentAdditionalServices(CreateOrder $method, ShipmentAdditionalServices $services)
    {
        if ($services->isServices(ShipmentAdditionalServices::SMS_NOTIFICATION_RECIPIENT)) {
            $method->addCourierService(new SmsNotificationRecipientCourierService(true));
        }

        if ($services->isServices(ShipmentAdditionalServices::COURIER_PRINTED_LABEL)) {
            $method->addCourierService(new CourierWithLabelCourierService(true));
        }

        if ($services->isServices(ShipmentAdditionalServices::COURIER_WEEK_COLLECTION)) {
            $method->addCourierService(new WeekCollectionCourierService(true));
        }
    }
}