<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */
namespace Polkurier\CollectionPoint;

final class CollectionPointModel extends CollectionPointSql
{

    /**
     * @param array $data
     * @return array
     */
    public static function PrepareArray($data = [])
    {
        return [
            'id_cart' => pSQL($data['id_cart']),
            'providers' => pSQL($data['providers']),
            'collection_point' => pSQL($data['collection_point']),
            'adres' => pSQL($data['adres']),
        ];
    }

    /**
     * @param array $data
     * @return int|string
     */
    public static function Insert($data = [])
    {
        return parent::insertSql(
            self::PrepareArray($data)
        );
    }

    /**
     * @param array $data
     * @param int $id
     * @return bool
     */
    public static function Update($data, $id)
    {
        return parent::updateSql(
            self::PrepareArray($data), $id
        );
    }

    /**
     * @param int $id_cart
     * @param string $providers
     * @return array|bool|object|null
     */
    public static function getChosenPoint($id_cart, $providers)
    {
        return parent::getCollectionPointByIdCartProviders((int)$id_cart, pSQL($providers));
    }

    /**
     * @param int $id_cart
     * @return array|bool|object|null
     */
    public static function getCollectionPoint($id_cart)
    {
        return parent::getCollectionPointByIdCart((int)$id_cart);
    }

    /**
     * @param int $id_cart
     * @param string $providers
     * @return array|bool|object|null
     */
    public static function getCollectionPointOtherProviders($id_cart, $providers)
    {
        return parent::getCollectionPointOtherProviders((int)$id_cart, pSQL($providers));
    }
}