<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Polkurier\ApiMetod\ApiUtils;
use Polkurier\ApiMetod\StatusOrderApi;
use Polkurier\Model\PolkurierConfig;
use Tools;

final class OrderPolkurier
{

    public function __construct()
    {
    }
    
    /**
     * @param int $page
     * @param int $limit
     * @param array $find
     * @return mixed
     */
    public function ListOrders($page = 1, $limit = 100, $find = [])
    {
        $order = OrdersModel::getOrderList($page, $limit, $find);
        if (is_array($order)) {
            foreach ($order as &$item) {
        
                $item['number_label'] = '<a href="' . $item['traking_url'] . '">' . $item['number_label'] . '</a>';
                $item = $this->UpdateStatusTraking($item);
                $item['receiver'] = self::SetReceiver($item);
                $item['url_presta_order'] = 'index.php?tab=AdminOrders&id_order=' . (int)$item['id_order_presta'] . '&vieworder' . '&token=' . Tools::getAdminTokenLite('AdminOrders');
            }
            return $order;
        }
        return null;
    }
    
    /**
     * @param $id
     * @return |null
     */
    public function ListOrdersByPrestaId($id)
    {
        $order = OrdersModel::getOrderListByOrderPresta($id);
        
        if (is_array($order)) {
            
            foreach ($order as &$item) {
                $item['number_label'] = '<a href="' . $item['traking_url'] . '">' . $item['number_label'] . '</a>';
                $item = $this->UpdateStatusTraking($item);
            }
            return $order;
        }
        return null;
    }
    
    /**
     * @return int
     */
    public static function CountOrder()
    {
        return OrdersModel::getCountOrder();
    }
    
    /**
     * @param $item
     * @return string
     */
    private static function SetReceiver($item)
    {
        $receiver = [];
        
        if (!empty($item['company'])) {
            $receiver[] = $item['company'];
        }
        if (!empty($item['first_name']) || !empty($item['last_name'])) {
            $receiver[] = $item['first_name'] . ' ' . $item['last_name'];
        }
        return implode(', ', $receiver);
    }
    
    /**
     * @param array $item
     * @return array
     */
    private function UpdateStatusTraking($item = [])
    {
        if (!in_array($item['status'], ConfigStatus::$skip_status) && (int)$item['cancel_order'] == 0) {
            
            if (round((time() - strtotime($item['status_date'])) / (60 * 60)) >= ConfigStatus::$status_interval) {
                
                $orderstatustraking = new OrderStatusTraking();
                $orderstatustraking->setIdOrderPresta($item['id_order_presta']);
                $orderstatustraking->setNumberOrder($item['number_order']);
                $orderstatustraking->setOrderId($item['order_id']);
                $status = $orderstatustraking->UpdateStatus();
                if(!is_null($status)){
                    $item['status'] = $status;
                }
            }
        }
        $item['status'] = ApiUtils::getStatusText($item['status']);
        return $item;
    }
    
    /**
     * @param int $id
     * @return array|bool|object|null
     */
    public function getOrderById($id)
    {
        return OrdersModel::getOrderById($id);
    }
    
    /**
     * @param int $id
     * @return array|bool|object|null
     */
    public function setCanceled($id)
    {
        return OrdersModel::CanceledOrder($id);
    }
}