<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Polkurier\ApiMetod\StatusOrderApi;
use Polkurier\ConfigurationKey;
use Polkurier\Model\PolkurierConfig;
use Exception;

final class OrderStatusTraking
{
    const DELIVERED_STATUS = 'D';
    
    /**
     * @var int
     */
    private $order_id;
    
    /**
     * @var string
     */
    private $number_order;
    
    /**
     * @var int
     */
    private $id_order_presta;
    
    /**
     * @return string|null
     */
    public function UpdateStatus()
    {
        try {
            
            $traking = (new StatusOrderApi())->getStatus($this->number_order);
            
            if (!empty($traking['status_code'])) {
                
                OrdersModel::UpdateTrackingOrder($this->order_id, $traking['status_code'], $traking['delivered_date']);
                
                /* update track => delivered */
                if ($traking['status_code'] == self::DELIVERED_STATUS) {
                    
                    if ((int)PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_SET_ORDER_STATUS_SHIPMENT) == 1) {
                        
                        UpdatePrestaOrderStatus::Update($this->id_order_presta, PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_STATUS_ORDER_STATUS_SHIPMENT));
                    }
                }
                return $traking['status_code'];
            }
        } catch (Exception $ex) {
            return null;
        }
        return null;
    }
    
    /**
     * @param int $order_id
     * @return $this
     */
    public function setOrderId($order_id)
    {
        $this->order_id = $order_id;
        return $this;
    }
    
    /**
     * @param string $number_order
     * @return $this
     */
    public function setNumberOrder($number_order)
    {
        $this->number_order = $number_order;
        return $this;
    }
    
    /**
     * @param int $id_order_presta
     * @return $this
     */
    public function setIdOrderPresta($id_order_presta)
    {
        $this->id_order_presta = $id_order_presta;
        return $this;
    }
}