<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Sender;

class SenderListModel
{
    /**
     * @var array
     */
    private static $list = [];
    /**
     * @var array
     */
    private static $list_option = [];
    
    /**
     * @param bool $refresh
     * @return array|false|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getList($refresh = false)
    {
        if (empty(self::$list) || $refresh === true) {
            self::$list = SenderModel::getSenderList();
        }
        return self::$list;
    }
    
    /**
     * @param bool $refresh
     * @return array
     */
    public static function getListOption($refresh = false)
    {
        if (empty(self::$list_option) || $refresh === true) {
            $list = self::getList();
            if(is_array($list)){
                foreach ($list as $item) {
                    self::$list_option[$item['sender_id']] = [
                        'id' => $item['sender_id'],
                        'name' => $item['name']
                    ];
                }
            }
        }
        return self::$list_option;
    }
    
    /**
     * @return false|string
     */
    public static function getListToJson()
    {
        return json_encode(self::getList());
    }
}