<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Sender;

use pSQL;

final class SenderModel extends SqlSender
{
    
    /**
     * @param array $data
     * @return array
     */
    public static function PrepareArraySender($data = [])
    {
        return [
            'name' => pSQL($data['name']),
            'company' => pSQL($data['company']),
            'first_name' => pSQL($data['first_name']),
            'last_name' => pSQL($data['last_name']),
            'street' => pSQL($data['street']),
            'house_no' => pSQL($data['house_no']),
            'flat_no' => pSQL($data['flat_no']),
            'postcode' => pSQL($data['postcode']),
            'city' => pSQL($data['city']),
            'contact_name' => pSQL($data['contact_name']),
            'email' => pSQL($data['email']),
            'phone' => pSQL($data['phone']),
        ];
    }
    
    /**
     * @param array $data
     * @return int|string
     */
    public static function InsertSender($data = [])
    {
        return parent::insertSql(
            self::PrepareArraySender($data)
        );
    }
    
    /**
     * @param array $data
     * @param int $id
     * @return bool
     */
    public static function UpdateSender($data, $id)
    {
        return parent::updateSql(
            self::PrepareArraySender($data), $id
        );
    }
    
    /**
     * @return array|false|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getSenderList()
    {
        $return = [];
        try {

            $result = parent::getAllSender();

            if(is_array($result)){
                foreach ($result as $item) {
                    $return[$item['sender_id']] = $item;
                }
            }

        } catch (PrestaShopDatabaseException $e) {
            return $return;
        }
        return $return;
    }
}